/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.codec;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.frame.Frame;
import io.kroxylicious.proxy.internal.codec.ByteBufAccessorImpl;
import io.kroxylicious.proxy.internal.codec.KafkaMessageListener;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.slf4j.Logger;

abstract class KafkaMessageEncoder<F extends Frame>
extends MessageToByteEncoder<F> {
    @Nullable
    private final KafkaMessageListener listener;

    KafkaMessageEncoder(@Nullable KafkaMessageListener listener) {
        this.listener = listener;
    }

    protected abstract Logger log();

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, F msg, boolean preferDirect) throws Exception {
        int bytes = msg.estimateEncodedSize();
        if (preferDirect) {
            return ctx.alloc().ioBuffer(bytes);
        }
        return ctx.alloc().heapBuffer(bytes);
    }

    protected void encode(ChannelHandlerContext ctx, F frame, ByteBuf out) throws Exception {
        this.log().trace("{}: Encoding {} to buffer {}", new Object[]{ctx, frame, out});
        int beforeIndex = out.writerIndex();
        frame.encode(new ByteBufAccessorImpl(out));
        if (this.listener != null) {
            int afterIndex = out.writerIndex();
            this.listener.onMessage((Frame)frame, afterIndex - beforeIndex);
        }
    }
}

