/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.filter;

import io.kroxylicious.proxy.filter.ApiVersionsRequestFilter;
import io.kroxylicious.proxy.filter.FilterContext;
import io.kroxylicious.proxy.filter.RequestFilterResult;
import io.kroxylicious.proxy.frame.DecodedRequestFrame;
import io.kroxylicious.proxy.internal.ApiVersionsServiceImpl;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;

public class ApiVersionsDowngradeFilter
implements ApiVersionsRequestFilter {
    private final ApiVersionsServiceImpl apiVersionsService;

    public ApiVersionsDowngradeFilter(ApiVersionsServiceImpl apiVersionsService) {
        this.apiVersionsService = Objects.requireNonNull(apiVersionsService);
    }

    private static RequestHeaderData apiVersionsRequestDowngradeHeader(int correlationId) {
        return new DowngradeRequestHeaderData().setCorrelationId(correlationId).setRequestApiKey(ApiKeys.API_VERSIONS.id).setRequestApiVersion((short)0);
    }

    public static DecodedRequestFrame<ApiVersionsRequestData> downgradeApiVersionsFrame(int correlationId) {
        RequestHeaderData requestHeaderData = ApiVersionsDowngradeFilter.apiVersionsRequestDowngradeHeader(correlationId);
        return new DecodedRequestFrame<ApiVersionsRequestData>(requestHeaderData.requestApiVersion(), correlationId, true, requestHeaderData, new DowngradeApiVersionsRequestData());
    }

    public CompletionStage<RequestFilterResult> onApiVersionsRequest(short apiVersion, RequestHeaderData header, ApiVersionsRequestData request, FilterContext context) {
        if (request instanceof DowngradeApiVersionsRequestData) {
            ApiVersionsResponseData.ApiVersionCollection collection = new ApiVersionsResponseData.ApiVersionCollection();
            ApiKeys apiVersions = ApiKeys.API_VERSIONS;
            ApiVersionsResponseData.ApiVersion version = new ApiVersionsResponseData.ApiVersion().setApiKey(apiVersions.id).setMinVersion(apiVersions.oldestVersion()).setMaxVersion(this.apiVersionsService.latestVersion(apiVersions));
            collection.add((ImplicitLinkedHashCollection.Element)version);
            ApiVersionsResponseData message = new ApiVersionsResponseData().setApiKeys(collection).setErrorCode(Errors.UNSUPPORTED_VERSION.code());
            return context.requestFilterResultBuilder().shortCircuitResponse((ApiMessage)message).completed();
        }
        return context.forwardRequest(header, (ApiMessage)request);
    }

    private static class DowngradeRequestHeaderData
    extends RequestHeaderData {
        private DowngradeRequestHeaderData() {
        }

        public void write(Writable writable, ObjectSerializationCache cache, short version) {
            throw new UnsupportedOperationException("DowngradeRequestHeaderData is read-only");
        }

        public int size(ObjectSerializationCache cache, short version) {
            throw new UnsupportedOperationException("DowngradeRequestHeaderData is read-only");
        }
    }

    private static class DowngradeApiVersionsRequestData
    extends ApiVersionsRequestData {
        private DowngradeApiVersionsRequestData() {
        }

        public void write(Writable writable, ObjectSerializationCache cache, short version) {
            throw new UnsupportedOperationException("DowngradeApiVersionsRequestData is read-only");
        }

        public int size(ObjectSerializationCache cache, short version) {
            throw new UnsupportedOperationException("DowngradeApiVersionsRequestData is read-only");
        }
    }
}

