/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.filter;

import io.kroxylicious.proxy.filter.FilterContext;
import io.kroxylicious.proxy.filter.RequestFilter;
import io.kroxylicious.proxy.filter.RequestFilterResult;
import io.kroxylicious.proxy.filter.RequestFilterResultBuilder;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EagerMetadataLearner
implements RequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EagerMetadataLearner.class);
    private static final Set<ApiKeys> KAFKA_PRELUDE = Set.of(ApiKeys.API_VERSIONS, ApiKeys.SASL_HANDSHAKE, ApiKeys.SASL_AUTHENTICATE);

    public CompletionStage<RequestFilterResult> onRequest(ApiKeys apiKey, RequestHeaderData header, ApiMessage body, FilterContext context) {
        if (KAFKA_PRELUDE.contains(apiKey)) {
            return context.requestFilterResultBuilder().forward((ApiMessage)header, body).completed();
        }
        RequestHeaderData requestHeader = this.determineMetadataRequestHeader(header);
        boolean useClientRequest = requestHeader.equals((Object)header);
        MetadataRequestData request = useClientRequest ? (MetadataRequestData)body : new MetadataRequestData();
        CompletableFuture<RequestFilterResult> future = new CompletableFuture<RequestFilterResult>();
        CompletionStage<Void> unused = context.sendRequest(requestHeader, (ApiMessage)request).thenAccept(metadataResponse -> {
            RequestFilterResultBuilder builder = context.requestFilterResultBuilder();
            if (useClientRequest) {
                future.complete((RequestFilterResult)builder.shortCircuitResponse((ApiMessage)metadataResponse).withCloseConnection().build());
            } else {
                future.complete((RequestFilterResult)builder.withCloseConnection().build());
            }
            LOGGER.info("Closing upstream bootstrap connection {} now that endpoint reconciliation is complete.", (Object)context.channelDescriptor());
        });
        return future;
    }

    private RequestHeaderData determineMetadataRequestHeader(RequestHeaderData header) {
        if (header.requestApiKey() == ApiKeys.METADATA.id) {
            return header;
        }
        return new RequestHeaderData().setRequestApiVersion((short)0);
    }
}

