/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.net;

import io.kroxylicious.proxy.internal.net.Endpoint;
import io.kroxylicious.proxy.internal.net.NetworkBindingOperation;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkBindRequest
extends NetworkBindingOperation<Channel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkBindRequest.class);
    private final CompletableFuture<Channel> future;
    private final Endpoint endpoint;

    public NetworkBindRequest(CompletableFuture<Channel> future, Endpoint endpoint) {
        super(endpoint.tls());
        this.future = future;
        this.endpoint = endpoint;
    }

    public Optional<String> getBindingAddress() {
        return this.endpoint.bindingAddress();
    }

    @Override
    public int port() {
        return this.endpoint.port();
    }

    @Override
    public CompletableFuture<Channel> getFuture() {
        return this.future;
    }

    @Override
    public void performBindingOperation(ServerBootstrap serverBootstrap, ExecutorService executorService) {
        try {
            ChannelFuture bind;
            int port = this.port();
            Optional<String> bindingAddress = this.endpoint.bindingAddress();
            if (bindingAddress.isPresent()) {
                LOGGER.debug("Binding {}:{}", (Object)bindingAddress.get(), (Object)port);
                bind = serverBootstrap.bind(bindingAddress.get(), port);
            } else {
                LOGGER.debug("Binding <any>:{}", (Object)port);
                bind = serverBootstrap.bind(port);
            }
            bind.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> executorService.execute(() -> {
                if (channelFuture.cause() != null) {
                    this.future.completeExceptionally(channelFuture.cause());
                } else {
                    this.future.complete(channelFuture.channel());
                }
            })));
        }
        catch (Throwable t) {
            this.future.completeExceptionally(t);
        }
    }
}

