/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.k8s;

import io.confluent.csid.config.provider.annotations.ConfigProviderKey;
import io.confluent.csid.config.provider.annotations.Description;
import io.confluent.csid.config.provider.annotations.DocumentationTip;
import io.confluent.csid.config.provider.common.AbstractConfigProvider;
import io.confluent.csid.config.provider.common.SecretRequest;
import io.confluent.csid.config.provider.k8s.K8sSecretConfigProviderConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="This config provider is used to retrieve secrets that are mounted to the current container in Kubernetes.")
@DocumentationTip(value="Config providers can be used with anything that supports the AbstractConfig base class that is shipped with Apache Kafka.")
@ConfigProviderKey(value="k8sSecret")
public class K8sSecretConfigProvider
extends AbstractConfigProvider<K8sSecretConfigProviderConfig> {
    private static final Logger log = LoggerFactory.getLogger(K8sSecretConfigProvider.class);

    protected K8sSecretConfigProviderConfig config(Map<String, ?> settings) {
        return new K8sSecretConfigProviderConfig(settings);
    }

    protected void configure() {
    }

    protected Map<String, String> getSecret(SecretRequest secretRequest) throws Exception {
        File secretDirectory = new File(secretRequest.path());
        log.info("Secret Directory: {}", (Object)secretDirectory);
        if (!secretDirectory.isAbsolute()) {
            throw new ConfigException(String.format("Config Directory must be an absolute path: %s", secretDirectory));
        }
        if (!secretDirectory.exists()) {
            throw new FileNotFoundException(String.format("Config Directory must be an absolute path: %s", secretDirectory));
        }
        if (!secretDirectory.isDirectory()) {
            throw new ConfigException(String.format("Config Directory must be a directory: %s", secretDirectory));
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (File key : secretDirectory.listFiles(File::isFile)) {
            log.debug("Reading {} to key {}", (Object)key.getAbsolutePath(), (Object)key.getName());
            byte[] buffer = Files.readAllBytes(key.toPath());
            String value = new String(buffer, StandardCharsets.UTF_8);
            result.put(key.getName(), value);
        }
        return result;
    }

    public ConfigDef config() {
        return K8sSecretConfigProviderConfig.config();
    }
}

