/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.common.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class Recommenders {
    public static ConfigDef.Recommender visibleIf(String configKey, Object value) {
        return new VisibleIfRecommender(configKey, value, ValidValuesCallback.EMPTY);
    }

    static class VisibleIfRecommender
    implements ConfigDef.Recommender {
        final String configKey;
        final Object value;
        final ValidValuesCallback validValuesCallback;

        VisibleIfRecommender(String configKey, Object value, ValidValuesCallback validValuesCallback) {
            this.configKey = configKey;
            this.value = value;
            this.validValuesCallback = validValuesCallback;
        }

        public List<Object> validValues(String s, Map<String, Object> map) {
            return this.validValuesCallback.validValues(s, map);
        }

        public boolean visible(String key, Map<String, Object> settings) {
            Object v = settings.get(this.configKey);
            return this.value.equals(v);
        }
    }

    public static interface ValidValuesCallback {
        public static final ValidValuesCallback EMPTY = (configItem, settings) -> Collections.emptyList();

        public List<Object> validValues(String var1, Map<String, Object> var2);
    }
}

