/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.common.config;

import io.confluent.csid.config.provider.common.config.ConfigUtils;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class Validators {
    public static ConfigDef.Validator validEnum(Class<? extends Enum> enumClass, Enum ... excludes) {
        String[] ex = new String[excludes.length];
        for (int i = 0; i < ex.length; ++i) {
            ex[i] = excludes[i].toString();
        }
        return ValidEnum.of(enumClass, ex);
    }

    static class ValidEnum
    implements ConfigDef.Validator {
        final Set<String> validEnums;
        final Class<?> enumClass;

        public static ValidEnum of(Class<?> enumClass, String ... excludes) {
            return new ValidEnum(enumClass, excludes);
        }

        private ValidEnum(Class<?> enumClass, String ... excludes) {
            LinkedHashSet<String> validEnums = new LinkedHashSet<String>();
            for (Object o : enumClass.getEnumConstants()) {
                String key = o.toString();
                validEnums.add(key);
            }
            Arrays.asList(excludes).forEach(validEnums::remove);
            this.validEnums = validEnums;
            this.enumClass = enumClass;
        }

        public void ensureValid(String s, Object o) {
            if (o instanceof String) {
                if (!this.validEnums.contains(o)) {
                    throw new ConfigException(s, (Object)String.format("'%s' is not a valid value for %s. Valid values are %s.", o, this.enumClass.getSimpleName(), ConfigUtils.enumValues(this.enumClass)));
                }
            } else if (o instanceof List) {
                List list = (List)o;
                for (Object i : list) {
                    this.ensureValid(s, i);
                }
            } else {
                throw new ConfigException(s, o, "Must be a String or List");
            }
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ");
            this.validEnums.stream().map(Object::toString).forEach(joiner::add);
            return "Matches: ``" + joiner + "``";
        }
    }
}

