/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.config.AdvancedSettings;
import io.confluent.gateway.config.admin.Admin;
import io.confluent.gateway.config.exception.GatewayConfigParseException;
import io.confluent.gateway.config.route.Route;
import io.confluent.gateway.config.secretstore.SecretStore;
import io.confluent.gateway.config.streamingdomain.StreamingDomain;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public record Gateway(@JsonProperty(value="name") String name, @JsonProperty(value="admin") Admin admin, @JsonProperty(value="secretStores") List<SecretStore> secretStores, @JsonProperty(value="streamingDomains") @NonNull List<StreamingDomain> streamingDomains, @JsonProperty(value="routes") @NonNull List<Route> routes, @JsonProperty(value="advanced") AdvancedSettings advancedSettings) {
    public static final String DEFAULT_NAME = "gateway";

    @Generated
    public Gateway(@JsonProperty(value="name") String name, @JsonProperty(value="admin") Admin admin, @JsonProperty(value="secretStores") List<SecretStore> secretStores, @JsonProperty(value="streamingDomains") @NonNull List<StreamingDomain> streamingDomains, @JsonProperty(value="routes") @NonNull List<Route> routes, @JsonProperty(value="advanced") AdvancedSettings advancedSettings) {
        if (streamingDomains == null) {
            throw new NullPointerException("streamingDomains is marked non-null but is null");
        }
        if (routes == null) {
            throw new NullPointerException("routes is marked non-null but is null");
        }
    }

    public static Gateway withDefaults(Gateway gateway) {
        if (gateway.streamingDomains().isEmpty()) {
            throw new GatewayConfigParseException("At least one streaming domain must be provided");
        }
        if (gateway.routes().isEmpty()) {
            throw new GatewayConfigParseException("At least one route must be provided");
        }
        String name = gateway.name() != null ? gateway.name() : DEFAULT_NAME;
        List<Object> secretStores = gateway.secretStores() != null ? gateway.secretStores() : Collections.emptyList();
        secretStores = secretStores.stream().map(SecretStore::withDefaults).toList();
        List<StreamingDomain> streamingDomains = gateway.streamingDomains().stream().map(StreamingDomain::withDefaults).toList();
        return new Gateway(name, Admin.withDefaults(gateway.admin()), secretStores, streamingDomains, gateway.routes().stream().map(Route::withDefaults).toList(), gateway.advancedSettings != null ? gateway.advancedSettings : new AdvancedSettings());
    }
}

