/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config.secret;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.confluent.gateway.config.exception.GatewayConfigParseException;
import io.confluent.gateway.config.secret.FilePasswordProvider;
import io.confluent.gateway.config.secret.InlinePasswordProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.DEDUCTION, defaultImpl=InlinePasswordProvider.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=InlinePasswordProvider.class, name="inline"), @JsonSubTypes.Type(value=FilePasswordProvider.class, name="file")})
public interface PasswordProvider {
    public String getPassword();

    default public void validate() {
        String password = this.getPassword();
        if (password == null) {
            throw new GatewayConfigParseException("Password provider returned null password");
        }
        if (password.trim().isEmpty()) {
            throw new GatewayConfigParseException("Password contains only whitespace or is empty");
        }
    }
}

