/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config.streamingdomain;

import io.confluent.gateway.config.exception.GatewayConfigParseException;
import lombok.NonNull;

public record NamedRange(@NonNull String name, int start, int end) {
    public NamedRange(@NonNull String name, int start, int end) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (start < 0 || end < 0 || start > end) {
            throw new GatewayConfigParseException("Invalid range: start must be non-negative and less than or equal to end");
        }
        if (name.isBlank()) {
            throw new GatewayConfigParseException("Name must not be null or empty");
        }
    }

    @Override
    @NonNull
    public String toString() {
        return "NodeRange[name=" + this.name + ", start=" + this.start + ", end=" + this.end + "]";
    }
}

