/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config.streamingdomain;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.config.exception.GatewayConfigParseException;
import io.confluent.gateway.config.streamingdomain.KafkaCluster;
import io.confluent.gateway.config.streamingdomain.StreamingDomainType;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public record StreamingDomain(@JsonProperty(value="name", required=true) @NonNull String name, @JsonProperty StreamingDomainType type, @JsonProperty(value="kafkaCluster", required=true) @NonNull KafkaCluster kafkaCluster) {
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9_-]{0,62}$");

    @Generated
    public StreamingDomain(@JsonProperty(value="name", required=true) @NonNull String name, @JsonProperty StreamingDomainType type, @JsonProperty(value="kafkaCluster", required=true) @NonNull KafkaCluster kafkaCluster) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (kafkaCluster == null) {
            throw new NullPointerException("kafkaCluster is marked non-null but is null");
        }
    }

    public static StreamingDomain withDefaults(StreamingDomain streamingDomain) {
        if (StringUtils.isBlank((CharSequence)streamingDomain.name())) {
            throw new GatewayConfigParseException("StreamingDomain name cannot be null or empty");
        }
        String name = streamingDomain.name().trim();
        if (!VALID_NAME_PATTERN.matcher(name).matches()) {
            throw new GatewayConfigParseException("StreamingDomain name '" + name + "' is invalid. Must be 1-63 characters, start/end with alphanumeric, contain only alphanumeric, hyphens, and underscores");
        }
        return new StreamingDomain(name, streamingDomain.type() != null ? streamingDomain.type() : StreamingDomainType.DEFAULT, KafkaCluster.withDefaults(streamingDomain.kafkaCluster(), name));
    }

    @Override
    @NonNull
    public String toString() {
        return "StreamingDomain[name='" + this.name + "', kafkaCluster=" + this.kafkaCluster.name() + "]";
    }
}

