# Gateway Startup Scripts

This directory contains shell scripts to run the Gateway application.

## Scripts

### `gateway`
Main script to run the Gateway application.

**Usage:**
```bash
# Run the gateway with a configuration file
./bin/gateway-start -c config/gateway-config.yaml

# Run in daemon mode
./bin/gateway-start -c config/gateway-config.yaml -daemon

# Show help
./bin/gateway-start --help
```

### `gateway-run-class`
Generic launcher script used by other scripts. This script handles:
- Classpath management (development and production)
- JVM options configuration
- Logging setup
- Daemon mode support

## Environment Variables

You can customize the gateway startup by setting these environment variables:

- `GATEWAY_HEAP_OPTS` - JVM heap settings (default: -Xmx2g)
- `GATEWAY_OPTS` - Additional JVM options
- `LOG_DIR` - Log directory path (default: logs/)
- `JAVA_HOME` - Java installation path
- `GATEWAY_CONFIG_DIR` - Configuration directory path

## Examples

### Basic usage:
```bash
./bin/gateway-start -c config/gateway-config.yaml
```

### With custom heap size:
```bash
GATEWAY_HEAP_OPTS="-Xms1g -Xmx1g" ./bin/gateway-start -c config/gateway-config.yaml
```

### Running as daemon:
```bash
./bin/gateway-start -c config/gateway-config.yaml -daemon
```

### With monitoring enabled:
Gateway uses Prometheus for metrics collection. Add this to your config file:
```yaml
management:
  bindAddress: 127.0.0.1
  port: 9093
  endpoints:
    prometheus: {}
```
Then access metrics at: http://localhost:9093/metrics

## Requirements

1. Java 11 or higher
2. Maven build completed (`mvn clean package`)
3. Configuration file (see config/gateway-config.yaml for example)
4. Log4j2 YAML configuration (config/log4j2.yaml)

## Configuration Files

- **Gateway Config**: `config/gateway-config.yaml` - Main application configuration
- **Logging Config**: `config/log4j2.yaml` - Log4j2 YAML configuration with rolling file appenders
- **Environment Variables**: Various GATEWAY_* variables for customization

## First Time Setup

1. Make scripts executable:
   ```bash
   chmod +x bin/gateway-run-class
   chmod +x bin/gateway-start
   ```

2. Build the project:
   ```bash
   mvn clean package
   ```

3. Run the gateway:
   ```bash
   ./bin/gateway-start -c config/gateway-config.yaml
   ```
