/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.app;

import io.confluent.gateway.app.BannerLogger;
import io.confluent.gateway.app.ConfigurationManager;
import io.confluent.gateway.app.GatewayFeatures;
import io.confluent.gateway.app.LicenseFeatureResolver;
import io.confluent.gateway.config.GatewayConfiguration;
import io.confluent.gateway.license.DefaultLicenseKeyResolver;
import io.kroxylicious.proxy.KafkaProxy;
import io.kroxylicious.proxy.config.Configuration;
import io.kroxylicious.proxy.config.PluginFactoryRegistry;
import io.kroxylicious.proxy.internal.config.Feature;
import io.kroxylicious.proxy.internal.config.Features;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="gateway", mixinStandardHelpOptions=true, versionProvider=VersionProvider.class, description={"A customizable wire protocol gateway for Apache Kafka"})
public class GatewayApplication
implements Callable<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"io.confluent.gateway.StartupShutdownLogger");
    private static final String UNKNOWN = "unknown";
    private final KafkaProxyBuilder kafkaProxyBuilder;
    private final ConfigurationManager configurationManager;
    private final LicenseFeatureResolver featureResolver;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-c", "--config"}, description={"name of the configuration file"}, required=true)
    private File configFile;
    @CommandLine.Option(names={"-l", "--license-file"}, description={"License file path"})
    private File licenseFile;

    GatewayApplication() {
        this(KafkaProxy::new);
    }

    GatewayApplication(KafkaProxyBuilder kafkaProxyBuilder) {
        this(kafkaProxyBuilder, new LicenseFeatureResolver(new DefaultLicenseKeyResolver(), true));
    }

    GatewayApplication(KafkaProxyBuilder kafkaProxyBuilder, LicenseFeatureResolver featureResolver) {
        this.kafkaProxyBuilder = kafkaProxyBuilder;
        this.configurationManager = new ConfigurationManager();
        this.featureResolver = featureResolver;
    }

    private static boolean isExplicitlyEnabled(Feature feature) {
        String variableName = "GATEWAY_UNLOCK_" + feature.name();
        String enabledString = System.getProperty(variableName, System.getenv(variableName));
        return Boolean.parseBoolean(enabledString);
    }

    private static Features getFeatures() {
        Features.FeaturesBuilder builder = Features.builder();
        Arrays.stream(Feature.values()).forEach(f -> {
            if (GatewayApplication.isExplicitlyEnabled(f)) {
                builder.enable(f);
            }
        });
        return builder.build();
    }

    private static void printBannerAndVersions(Features features) throws Exception {
        String[] versions;
        new BannerLogger().log();
        for (String version : versions = new VersionProvider().getVersion()) {
            LOGGER.info("{}", (Object)version);
        }
        features.warnings().forEach(arg_0 -> ((Logger)LOGGER).warn(arg_0));
        LOGGER.atInfo().setMessage("Platform: Java {}({}) running on {} {}/{}").addArgument(Runtime::version).addArgument(() -> System.getProperty("java.vendor")).addArgument(() -> System.getProperty("os.name")).addArgument(() -> System.getProperty("os.version")).addArgument(() -> System.getProperty("os.arch")).log();
    }

    public static void main(String ... args) {
        GatewayApplication application = new GatewayApplication();
        int exitCode = new CommandLine((Object)application).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        if (!this.configFile.exists()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Given configuration file does not exist: %s", this.configFile.toPath().toAbsolutePath()));
        }
        GatewayFeatures gatewayFeatures = this.featureResolver.resolveFeatures(this.licenseFile);
        LOGGER.info(gatewayFeatures.toString());
        LOGGER.info("Reading configuration from {}", (Object)this.configFile.toPath());
        GatewayConfiguration gatewayConfiguration = this.configurationManager.parseGatewayConfig(this.configFile);
        gatewayFeatures.ensureConfigCompatibility(gatewayConfiguration);
        Path krxConfigPath = this.configurationManager.createKrxConfig(gatewayConfiguration, this.configFile);
        try (InputStream stream = Files.newInputStream(krxConfigPath, new OpenOption[0]);){
            Configuration config = this.configurationManager.parseKrxConfig(stream);
            Features features = GatewayApplication.getFeatures();
            GatewayApplication.printBannerAndVersions(features);
            try (KafkaProxy kafkaProxy = this.kafkaProxyBuilder.build((PluginFactoryRegistry)this.configurationManager.getKrxConfigParser(), config, features);){
                kafkaProxy.startup();
                kafkaProxy.block();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception on startup", (Throwable)e);
            throw e;
        }
        return 0;
    }

    static interface KafkaProxyBuilder {
        public KafkaProxy build(PluginFactoryRegistry var1, Configuration var2, Features var3);
    }

    static class VersionProvider
    implements CommandLine.IVersionProvider {
        VersionProvider() {
        }

        public String[] getVersion() throws Exception {
            try (InputStream resource = this.getClass().getClassLoader().getResourceAsStream("META-INF/gateway-metadata.properties");){
                if (resource != null) {
                    Properties properties = new Properties();
                    properties.load(resource);
                    String version = properties.getProperty("version", GatewayApplication.UNKNOWN);
                    String[] stringArray = new String[]{"gateway: " + version};
                    return stringArray;
                }
            }
            return new String[]{GatewayApplication.UNKNOWN};
        }
    }
}

