/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.app;

import io.confluent.gateway.app.GatewayFeatures;
import io.confluent.gateway.config.GatewayConfiguration;
import io.confluent.gateway.config.streamingdomain.BootstrapServer;
import io.confluent.license.InvalidLicenseException;
import io.kroxylicious.proxy.service.HostPort;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayFeatureValidator {
    public static final String ROUTE_LIMIT_EXCEEDED_MSG = "Cannot configure %d routes. License allows maximum %d routes.";
    public static final String CLOUD_ROUTES_CONFIGURED_WITHOUT_LICENSE_MSG = "Cloud add-on license not present. Found confluent cloud endpoints: %s";
    public static final String ONPREM_ROUTES_CONFIGURED_WITHOUT_LICENSE_MSG = "CPC license is expired or missing. Found on-premise endpoints: %s";
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayFeatureValidator.class);
    private static final List<String> confluentCloudDomains = List.of("confluent.cloud", "devel.cpdev.cloud");
    private final GatewayFeatures features;

    public void validate(GatewayConfiguration config) {
        this.validateMaxRoutes(config);
        this.validateCCloudRoutes(config);
        this.validateOnPremRoutes(config);
    }

    private void validateMaxRoutes(GatewayConfiguration config) {
        if (!this.features.unlimitedRoutes() && this.features.getMaxRoutes() < config.gateway().routes().size()) {
            String errorMessage = String.format(ROUTE_LIMIT_EXCEEDED_MSG, config.gateway().routes().size(), this.features.getMaxRoutes());
            LOGGER.error(errorMessage);
            throw new InvalidLicenseException(errorMessage);
        }
    }

    private void validateCCloudRoutes(GatewayConfiguration config) {
        if (!this.features.isCloudRoutingEnabled()) {
            ArrayList badEndpoints = new ArrayList();
            boolean hasCCloudRoute = config.gateway().streamingDomains().stream().anyMatch(sd -> sd.kafkaCluster().bootstrapServers().stream().anyMatch(bs -> {
                boolean isCCloud = this.isCCloudEndpoint((BootstrapServer)bs);
                if (isCCloud) {
                    badEndpoints.add(bs.getHostPort());
                }
                return isCCloud;
            }));
            if (hasCCloudRoute) {
                String errorMessage = String.format(CLOUD_ROUTES_CONFIGURED_WITHOUT_LICENSE_MSG, String.join((CharSequence)", ", badEndpoints));
                LOGGER.error(errorMessage);
                throw new InvalidLicenseException(errorMessage);
            }
        }
    }

    private void validateOnPremRoutes(GatewayConfiguration config) {
        if (!this.features.isOnPremiseRoutingEnabled()) {
            ArrayList badEndpoints = new ArrayList();
            boolean hasOnPremRoute = config.gateway().streamingDomains().stream().anyMatch(sd -> sd.kafkaCluster().bootstrapServers().stream().anyMatch(bs -> {
                boolean isCCloud = this.isCCloudEndpoint((BootstrapServer)bs);
                if (!isCCloud) {
                    badEndpoints.add(bs.getHostPort());
                }
                return !isCCloud;
            }));
            if (hasOnPremRoute) {
                String errorMessage = String.format(ONPREM_ROUTES_CONFIGURED_WITHOUT_LICENSE_MSG, String.join((CharSequence)", ", badEndpoints));
                LOGGER.error(errorMessage);
                throw new InvalidLicenseException(errorMessage);
            }
        }
    }

    private boolean isCCloudEndpoint(BootstrapServer bootstrapServer) {
        if (bootstrapServer == null) {
            return false;
        }
        try {
            String address = bootstrapServer.getHostPort();
            HostPort hostPort = HostPort.parse((String)address);
            String host = hostPort.host();
            return confluentCloudDomains.stream().anyMatch(host::endsWith);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to parse endpoint: {}", (Object)bootstrapServer, (Object)e);
            return false;
        }
    }

    @Generated
    public GatewayFeatureValidator(GatewayFeatures features) {
        this.features = features;
    }
}

