/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.app;

import io.confluent.gateway.app.GatewayFeatureValidator;
import io.confluent.gateway.config.GatewayConfiguration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayFeatures {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayFeatures.class);
    private static final int DEFAULT_MAX_ROUTES = 4;
    private static final int UNLIMITED_ROUTES = -1;
    private boolean onPremiseRoutingEnabled;
    private boolean cloudRoutingEnabled;
    private int maxRoutes;

    public static int getDefaultMaxRoutes() {
        return 4;
    }

    public void ensureConfigCompatibility(GatewayConfiguration gatewayConfiguration) {
        GatewayFeatureValidator gatewayFeatureValidator = new GatewayFeatureValidator(this);
        gatewayFeatureValidator.validate(gatewayConfiguration);
    }

    public boolean unlimitedRoutes() {
        return this.maxRoutes == -1;
    }

    public String toString() {
        return "GatewayFeatures{onPremiseRoutingEnabled=" + this.onPremiseRoutingEnabled + ", cloudRoutingEnabled=" + this.cloudRoutingEnabled + ", maxRoutes=" + String.valueOf(this.unlimitedRoutes() ? "unlimited" : Integer.valueOf(this.maxRoutes)) + "}";
    }

    @Generated
    private static boolean $default$onPremiseRoutingEnabled() {
        return false;
    }

    @Generated
    private static boolean $default$cloudRoutingEnabled() {
        return false;
    }

    @Generated
    private static int $default$maxRoutes() {
        return 4;
    }

    @Generated
    GatewayFeatures(boolean onPremiseRoutingEnabled, boolean cloudRoutingEnabled, int maxRoutes) {
        this.onPremiseRoutingEnabled = onPremiseRoutingEnabled;
        this.cloudRoutingEnabled = cloudRoutingEnabled;
        this.maxRoutes = maxRoutes;
    }

    @Generated
    public static GatewayFeaturesBuilder builder() {
        return new GatewayFeaturesBuilder();
    }

    @Generated
    public boolean isOnPremiseRoutingEnabled() {
        return this.onPremiseRoutingEnabled;
    }

    @Generated
    public boolean isCloudRoutingEnabled() {
        return this.cloudRoutingEnabled;
    }

    @Generated
    public int getMaxRoutes() {
        return this.maxRoutes;
    }

    public static class GatewayFeaturesBuilder {
        @Generated
        private boolean onPremiseRoutingEnabled$set;
        @Generated
        private boolean onPremiseRoutingEnabled$value;
        @Generated
        private boolean cloudRoutingEnabled$set;
        @Generated
        private boolean cloudRoutingEnabled$value;
        @Generated
        private boolean maxRoutes$set;
        @Generated
        private int maxRoutes$value;

        public GatewayFeaturesBuilder unlimitedRoutes() {
            this.maxRoutes(-1);
            return this;
        }

        public GatewayFeaturesBuilder unlimitedRoutes(boolean enabled) {
            this.maxRoutes(enabled ? -1 : 4);
            return this;
        }

        @Generated
        GatewayFeaturesBuilder() {
        }

        @Generated
        public GatewayFeaturesBuilder onPremiseRoutingEnabled(boolean onPremiseRoutingEnabled) {
            this.onPremiseRoutingEnabled$value = onPremiseRoutingEnabled;
            this.onPremiseRoutingEnabled$set = true;
            return this;
        }

        @Generated
        public GatewayFeaturesBuilder cloudRoutingEnabled(boolean cloudRoutingEnabled) {
            this.cloudRoutingEnabled$value = cloudRoutingEnabled;
            this.cloudRoutingEnabled$set = true;
            return this;
        }

        @Generated
        public GatewayFeaturesBuilder maxRoutes(int maxRoutes) {
            this.maxRoutes$value = maxRoutes;
            this.maxRoutes$set = true;
            return this;
        }

        @Generated
        public GatewayFeatures build() {
            boolean onPremiseRoutingEnabled$value = this.onPremiseRoutingEnabled$value;
            if (!this.onPremiseRoutingEnabled$set) {
                onPremiseRoutingEnabled$value = GatewayFeatures.$default$onPremiseRoutingEnabled();
            }
            boolean cloudRoutingEnabled$value = this.cloudRoutingEnabled$value;
            if (!this.cloudRoutingEnabled$set) {
                cloudRoutingEnabled$value = GatewayFeatures.$default$cloudRoutingEnabled();
            }
            int maxRoutes$value = this.maxRoutes$value;
            if (!this.maxRoutes$set) {
                maxRoutes$value = GatewayFeatures.$default$maxRoutes();
            }
            return new GatewayFeatures(onPremiseRoutingEnabled$value, cloudRoutingEnabled$value, maxRoutes$value);
        }

        @Generated
        public String toString() {
            return "GatewayFeatures.GatewayFeaturesBuilder(onPremiseRoutingEnabled$value=" + this.onPremiseRoutingEnabled$value + ", cloudRoutingEnabled$value=" + this.cloudRoutingEnabled$value + ", maxRoutes$value=" + this.maxRoutes$value + ")";
        }
    }
}

