/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.app;

import io.confluent.gateway.app.GatewayFeatures;
import io.confluent.gateway.license.DefaultLicenseKeyResolver;
import io.confluent.gateway.license.LicenseKeyResolver;
import io.confluent.gateway.license.LicenseVerifier;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseFeatureResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseFeatureResolver.class);
    private final LicenseKeyResolver licenseKeyResolver;
    private final boolean allowCPLicense;

    public LicenseFeatureResolver() {
        this(new DefaultLicenseKeyResolver());
    }

    public LicenseFeatureResolver(LicenseKeyResolver licenseKeyResolver) {
        this(licenseKeyResolver, false);
    }

    private static boolean isEnterpriseLicense(JwtClaims jwtClaims) {
        String licenseType = (String)jwtClaims.getClaimValue("licenseType");
        return licenseType != null && Objects.equals(licenseType.toLowerCase(), "Enterprise".toLowerCase());
    }

    private static boolean isExpired(JwtClaims jwtClaims) {
        try {
            return jwtClaims.getExpirationTime().getValueInMillis() < System.currentTimeMillis();
        }
        catch (MalformedClaimException e) {
            LOGGER.warn("Failed to parse expiration claim", (Throwable)e);
            return true;
        }
        catch (NullPointerException e) {
            LOGGER.warn("Expiration claim is missing", (Throwable)e);
            return true;
        }
    }

    private static boolean isCloudLicense(JwtClaims jwtClaims) {
        List cloudSKUs;
        Object claimValue = jwtClaims.getClaimValue("addon");
        if (!(claimValue instanceof Map)) {
            return false;
        }
        Map addon = (Map)claimValue;
        Object ccServices = addon.get("cc_service");
        if (!(ccServices instanceof List) || (cloudSKUs = (List)ccServices).isEmpty()) {
            return false;
        }
        return cloudSKUs.stream().anyMatch(sku -> {
            boolean isCloudGatewayAddon;
            if (!(sku instanceof Map)) {
                return false;
            }
            Map skuMap = (Map)sku;
            String skuValue = (String)skuMap.get("SKU");
            boolean bl = isCloudGatewayAddon = skuValue != null && Objects.equals(skuValue.toUpperCase(), "GTWY-CCADDON");
            if (isCloudGatewayAddon) {
                Object expValue = skuMap.get("exp");
                if (expValue instanceof Number) {
                    Number expNumber = (Number)expValue;
                    long expSeconds = expNumber.longValue();
                    return expSeconds >= System.currentTimeMillis() / 1000L;
                }
                return false;
            }
            return false;
        });
    }

    private boolean isPrivateCloudLicense(JwtClaims jwtClaims) {
        if (LicenseFeatureResolver.isExpired(jwtClaims)) {
            return false;
        }
        if (this.allowCPLicense && LicenseFeatureResolver.isEnterpriseLicense(jwtClaims)) {
            return true;
        }
        String licenseSubtype = (String)jwtClaims.getClaimValue("licenseSubType");
        return licenseSubtype != null && Objects.equals(licenseSubtype.toLowerCase(), "PrivateCloud".toLowerCase());
    }

    public GatewayFeatures resolveFeatures(File licenseFile) {
        return this.resolveFeatures(new LicenseVerifier(this.licenseKeyResolver), licenseFile);
    }

    public GatewayFeatures resolveFeatures(LicenseVerifier licenseParser, File licenseFile) {
        return this.resolveFeatures(licenseParser.verify(licenseFile));
    }

    public GatewayFeatures resolveFeatures(List<JwtClaims> jwtClaimsCollection) {
        GatewayFeatures.GatewayFeaturesBuilder features = GatewayFeatures.builder();
        boolean isTrial = true;
        for (JwtClaims jwtClaims : jwtClaimsCollection) {
            if (this.isPrivateCloudLicense(jwtClaims)) {
                features.onPremiseRoutingEnabled(true).unlimitedRoutes(true);
                isTrial = false;
            }
            if (!LicenseFeatureResolver.isCloudLicense(jwtClaims)) continue;
            features.cloudRoutingEnabled(true).unlimitedRoutes(true);
            isTrial = false;
        }
        if (isTrial) {
            LOGGER.info("No valid Enterprise license found. Applying trial feature limits.");
            features.onPremiseRoutingEnabled(true).cloudRoutingEnabled(true).maxRoutes(GatewayFeatures.getDefaultMaxRoutes());
        }
        return features.build();
    }

    @Generated
    public LicenseFeatureResolver(LicenseKeyResolver licenseKeyResolver, boolean allowCPLicense) {
        this.licenseKeyResolver = licenseKeyResolver;
        this.allowCPLicense = allowCPLicense;
    }
}

