/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config.admin;

import io.confluent.gateway.config.admin.Endpoints;
import io.confluent.gateway.config.exception.GatewayConfigParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public record Admin(String bindAddress, Integer port, Endpoints endpoints, List<String> jvmMetrics, Map<String, String> commonTags) {
    public static final String DEFAULT_BIND_ADDRESS = "0.0.0.0";
    public static final int DEFAULT_PORT = 9190;
    public static final List<String> DEFAULT_JVM_METRICS = List.of("JvmGcMetrics", "JvmMemoryMetrics", "JvmThreadMetrics", "ProcessorMetrics", "UptimeMetrics");

    public Admin {
        if (port != null && (port < 1 || port > 65535)) {
            throw new GatewayConfigParseException("Port must be between 1 and 65535, got: " + port);
        }
        if (bindAddress != null && bindAddress.trim().isEmpty()) {
            throw new GatewayConfigParseException("bindAddress cannot be empty");
        }
    }

    public static Admin withDefaults(Admin admin) {
        if (admin == null) {
            return new Admin(DEFAULT_BIND_ADDRESS, 9190, new Endpoints(), DEFAULT_JVM_METRICS, Collections.emptyMap());
        }
        String effectiveBindAddress = Optional.ofNullable(admin.bindAddress).filter(address -> !address.trim().isEmpty()).orElse(DEFAULT_BIND_ADDRESS);
        int effectivePort = Optional.ofNullable(admin.port).orElse(9190);
        Endpoints effectiveEndpoints = Optional.ofNullable(admin.endpoints).orElse(new Endpoints());
        List<String> effectiveJvmMetrics = Optional.ofNullable(admin.jvmMetrics).orElse(DEFAULT_JVM_METRICS);
        return new Admin(effectiveBindAddress, effectivePort, effectiveEndpoints, effectiveJvmMetrics, admin.commonTags);
    }

    @NonNull
    public String getEffectiveBindAddress() {
        return Optional.ofNullable(this.bindAddress).orElse(DEFAULT_BIND_ADDRESS);
    }

    public int getEffectivePort() {
        return Optional.ofNullable(this.port).orElse(9190);
    }

    @NonNull
    public Endpoints getEffectiveEndpoints() {
        return Optional.ofNullable(this.endpoints).orElse(new Endpoints());
    }

    @Override
    @NonNull
    public String toString() {
        return String.format("Admin[bindAddress='%s', port=%d, endpoints=%s, jvmMetrics=%s, commonTags=%s]", this.getEffectiveBindAddress(), this.getEffectivePort(), this.getEffectiveEndpoints(), this.jvmMetrics(), this.commonTags());
    }
}

