/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config.route;

import io.confluent.gateway.config.exception.GatewayConfigParseException;
import io.confluent.gateway.config.route.StrategyType;
import lombok.NonNull;

public record BrokerIdentificationStrategy(StrategyType type, String pattern) {
    public static final BrokerIdentificationStrategy DEFAULT = new BrokerIdentificationStrategy(StrategyType.PORT, null);

    public BrokerIdentificationStrategy {
        if (type == null) {
            type = StrategyType.DEFAULT;
        }
        if (type == StrategyType.HOST && (pattern == null || pattern.isBlank())) {
            throw new GatewayConfigParseException("Pattern must be provided for HOST strategy");
        }
    }

    public boolean isPortStrategy() {
        return this.type == StrategyType.PORT;
    }

    public boolean isHostStrategy() {
        return this.type == StrategyType.HOST;
    }

    @Override
    @NonNull
    public String toString() {
        return "BrokerIdentificationStrategy[type=" + String.valueOf((Object)this.type) + ", pattern=" + this.pattern + "]";
    }
}

