/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config.secret;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.config.exception.GatewayConfigParseException;
import io.confluent.gateway.config.secret.PasswordProvider;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public record InlinePasswordProvider(@JsonProperty(value="value", required=true) @NonNull String password) implements PasswordProvider
{
    public InlinePasswordProvider(@JsonProperty(value="value", required=true) @NonNull String password) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new GatewayConfigParseException("Inline password cannot be empty or whitespace-only");
        }
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void validate() {
        if (this.password.isEmpty()) {
            throw new GatewayConfigParseException("Password cannot be empty");
        }
        String trimmed = this.password.trim();
        if (trimmed.length() != this.password.length()) {
            throw new GatewayConfigParseException("Password should not have leading/trailing whitespace");
        }
    }

    @Override
    @NonNull
    public String toString() {
        return "InlinePasswordProvider[masked=*******]";
    }
}

