/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config.secretstore;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.common.secretprovider.ProviderConfig;
import io.confluent.gateway.config.exception.GatewayConfigParseException;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public record SecretStore(@JsonProperty(required=true) String name, @JsonProperty(value="provider") ProviderConfig provider) {
    public static SecretStore withDefaults(@NonNull SecretStore secretStore) {
        if (secretStore == null) {
            throw new NullPointerException("secretStore is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)secretStore.name())) {
            throw new GatewayConfigParseException("Secret store name must not be null or empty");
        }
        if (secretStore.provider() == null) {
            throw new GatewayConfigParseException("Secret store provider must not be null");
        }
        return new SecretStore(secretStore.name(), secretStore.provider());
    }

    @Override
    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SecretStore[");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", provider=").append(this.provider.type());
        sb.append("]");
        return sb.toString();
    }
}

