/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config.ssl;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.config.exception.GatewayConfigParseException;
import io.confluent.gateway.config.ssl.ClientAuth;
import io.confluent.gateway.config.ssl.Keystore;
import io.confluent.gateway.config.ssl.Truststore;
import lombok.NonNull;

public record Ssl(boolean ignoreTrust, @JsonProperty(value="truststore") Truststore truststore, @JsonProperty(value="keystore") Keystore keystore, @JsonProperty(value="clientAuth") ClientAuth clientAuth) {
    public Ssl(boolean ignoreTrust, Truststore truststore, Keystore keystore) {
        this(ignoreTrust, truststore, keystore, ClientAuth.NONE);
    }

    public static Ssl withDefaults(Ssl ssl) {
        ClientAuth defaultClientAuth;
        Truststore defaultTruststore = ssl.truststore != null ? Truststore.withDefaults(ssl.truststore) : null;
        Keystore defaultKeystore = ssl.keystore != null ? Keystore.withDefaults(ssl.keystore) : null;
        ClientAuth clientAuth = defaultClientAuth = ssl.clientAuth != null ? ssl.clientAuth : ClientAuth.NONE;
        if (defaultClientAuth != ClientAuth.NONE && ssl.truststore() == null) {
            throw new GatewayConfigParseException("ClientAuth requires a truststore to be configured");
        }
        return new Ssl(ssl.ignoreTrust(), defaultTruststore, defaultKeystore, ssl.clientAuth() == null ? ClientAuth.DEFAULT : ssl.clientAuth());
    }

    @Override
    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder("Ssl[");
        sb.append("ignoreTrust=").append(this.ignoreTrust);
        sb.append("truststore=").append(this.truststore);
        sb.append(", keystore=").append(this.keystore);
        sb.append(", clientAuth=").append((Object)this.clientAuth);
        sb.append(']');
        return sb.toString();
    }
}

