/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config.ssl;

import io.confluent.gateway.config.exception.GatewayConfigParseException;
import io.confluent.gateway.config.secret.PasswordProvider;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

interface Store {
    public static final Set<String> SUPPORTED_TYPES = Set.of("JKS", "PKCS12", "PEM");
    public static final String DEFAULT_TYPE = "JKS";

    default public void validate() {
        if (StringUtils.isBlank((CharSequence)this.location())) {
            throw new GatewayConfigParseException("Store location cannot be null or empty");
        }
        if (StringUtils.isBlank((CharSequence)this.type())) {
            throw new GatewayConfigParseException("Store type cannot be null or empty");
        }
        if (!SUPPORTED_TYPES.contains(this.type().toUpperCase())) {
            throw new GatewayConfigParseException("Unsupported store type: " + this.type() + ". Supported types: " + String.valueOf(SUPPORTED_TYPES));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    default public String getEffectiveType() {
        String storeType = StringUtils.trimToEmpty((String)this.type());
        return StringUtils.isEmpty((CharSequence)storeType) ? DEFAULT_TYPE : storeType.trim().toUpperCase();
    }

    default public String getEffectiveLocation() {
        return StringUtils.trimToEmpty((String)this.location()).trim();
    }

    public String location();

    public String type();

    public PasswordProvider password();
}

