/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config.streamingdomain;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.config.exception.GatewayConfigParseException;
import io.confluent.gateway.config.streamingdomain.BootstrapServer;
import io.confluent.gateway.config.streamingdomain.NamedRange;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public record KafkaCluster(@JsonProperty String name, @JsonProperty(required=true) @NonNull List<BootstrapServer> bootstrapServers, @JsonProperty List<NamedRange> nodeIdRanges) {
    @Generated
    public KafkaCluster(@JsonProperty String name, @JsonProperty(required=true) @NonNull List<BootstrapServer> bootstrapServers, @JsonProperty List<NamedRange> nodeIdRanges) {
        if (bootstrapServers == null) {
            throw new NullPointerException("bootstrapServers is marked non-null but is null");
        }
    }

    public static KafkaCluster withDefaults(KafkaCluster kafkaCluster, String namespace) {
        if (kafkaCluster.bootstrapServers().isEmpty()) {
            throw new GatewayConfigParseException("Bootstrap servers must not be null or empty" + kafkaCluster.name());
        }
        long uniqueServerIdCount = kafkaCluster.bootstrapServers().stream().map(BootstrapServer::id).distinct().count();
        if (uniqueServerIdCount != (long)kafkaCluster.bootstrapServers().size()) {
            throw new GatewayConfigParseException("Bootstrap servers must have unique IDs, found duplicates in: " + String.valueOf(kafkaCluster.bootstrapServers()));
        }
        return new KafkaCluster((String)(kafkaCluster.name == null ? namespace : namespace + "." + kafkaCluster.name), kafkaCluster.bootstrapServers(), kafkaCluster.nodeIdRanges());
    }

    @Override
    @NonNull
    public String toString() {
        return "KafkaCluster[name='" + this.name + "', bootstrapServers='" + String.valueOf(this.bootstrapServers) + "', nodeIdRanges=" + String.valueOf(this.nodeIdRanges == null ? "null" : this.nodeIdRanges) + "]";
    }
}

