/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.configadapter.builder;

import io.confluent.gateway.config.Gateway;
import io.confluent.gateway.config.route.Route;
import io.confluent.gateway.config.secretstore.SecretStore;
import io.confluent.gateway.config.streamingdomain.BootstrapServer;
import io.confluent.gateway.config.streamingdomain.StreamingDomain;
import io.confluent.gateway.configadapter.builder.FilterDefinitionBuilder;
import io.confluent.gateway.configadapter.builder.ManagementConfigurationBuilder;
import io.confluent.gateway.configadapter.builder.VirtualClusterConfigurationBuilder;
import io.confluent.gateway.configadapter.mapbuilder.ConfigMapBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KroxyliciousConfigurationBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(KroxyliciousConfigurationBuilder.class);
    private final ManagementConfigurationBuilder managementBuilder;
    private final VirtualClusterConfigurationBuilder virtualClusterBuilder;
    private final List<Map<String, Object>> filterDefinitions;

    public KroxyliciousConfigurationBuilder(Gateway gateway) {
        Map<String, SecretStore> secretStoreMap = ConfigMapBuilder.buildSecretStoreMap(gateway);
        Map<String, StreamingDomain> streamingDomainMap = ConfigMapBuilder.buildStreamingDomainMap(gateway);
        Map<String, Map<String, BootstrapServer>> bootstrapServerMap = ConfigMapBuilder.buildBootstrapServerMap(gateway);
        this.managementBuilder = new ManagementConfigurationBuilder();
        FilterDefinitionBuilder filterBuilder = new FilterDefinitionBuilder(secretStoreMap);
        this.filterDefinitions = filterBuilder.build(gateway);
        Map<String, List<String>> routeFiltersMap = filterBuilder.getRouteFiltersMap();
        this.virtualClusterBuilder = new VirtualClusterConfigurationBuilder(streamingDomainMap, bootstrapServerMap, routeFiltersMap);
        LOGGER.debug("KroxyliciousConfigurationBuilder initialized with {} secret stores, {} streaming domains, {} routes, {} filter definitions", new Object[]{secretStoreMap.size(), streamingDomainMap.size(), gateway.routes().size(), this.filterDefinitions.size()});
    }

    public Map<String, Object> build(Gateway gateway) {
        LOGGER.debug("Building Kroxylicious configuration");
        LinkedHashMap<String, Object> configuration = new LinkedHashMap<String, Object>();
        this.addFilterConfiguration(configuration);
        this.addVirtualClusterConfiguration(configuration, gateway);
        this.addManagementConfiguration(configuration, gateway);
        this.addAdvancedSettings(configuration, gateway);
        LOGGER.info("Kroxylicious configuration created with {} virtual clusters", (Object)gateway.routes().size());
        return configuration;
    }

    private void addManagementConfiguration(Map<String, Object> configuration, Gateway gateway) {
        List<Map<String, Object>> micrometerConfig;
        Map<String, Object> managementConfig = this.managementBuilder.build(gateway.admin());
        if (managementConfig != null) {
            configuration.put("management", managementConfig);
        }
        if (!ObjectUtils.isEmpty(micrometerConfig = this.managementBuilder.buildMicrometerConfig(gateway.admin()))) {
            configuration.put("micrometer", micrometerConfig);
        } else {
            LOGGER.debug("No micrometer configuration added as it is empty or not applicable");
        }
        LOGGER.debug("Management configuration added: {}", (Object)(managementConfig != null ? 1 : 0));
    }

    private void addFilterConfiguration(Map<String, Object> configuration) {
        configuration.put("filterDefinitions", this.filterDefinitions);
        configuration.put("defaultFilters", Collections.emptyList());
        LOGGER.debug("Filter configuration added with {} filter definitions", (Object)this.filterDefinitions.size());
    }

    private void addVirtualClusterConfiguration(Map<String, Object> configuration, Gateway gateway) {
        List<Map<String, Object>> virtualClusters = this.buildVirtualClusters(gateway);
        configuration.put("virtualClusters", virtualClusters);
        LOGGER.debug("Virtual cluster configuration added with {} clusters", (Object)virtualClusters.size());
    }

    private void addAdvancedSettings(Map<String, Object> configuration, Gateway gateway) {
        if (gateway.advancedSettings() != null) {
            configuration.put("useIoUring", gateway.advancedSettings().useIoUring());
            LOGGER.debug("Advanced settings added: useIoUring={}", (Object)gateway.advancedSettings().useIoUring());
        }
    }

    private List<Map<String, Object>> buildVirtualClusters(Gateway gateway) {
        return gateway.routes().stream().map(route -> {
            LOGGER.debug("Building virtual cluster configuration for route: {}", (Object)route.name());
            return this.virtualClusterBuilder.buildVirtualClusterConfiguration((Route)route);
        }).collect(Collectors.toList());
    }
}

