/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.configadapter.builder;

import io.confluent.gateway.config.admin.Admin;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ManagementConfigurationBuilder {
    public Map<String, Object> build(Admin admin) {
        if (admin == null) {
            return null;
        }
        LinkedHashMap<String, Object> managementConfig = new LinkedHashMap<String, Object>();
        managementConfig.put("bindAddress", admin.bindAddress());
        managementConfig.put("port", admin.port());
        if (this.shouldEnablePrometheusEndpoint(admin)) {
            managementConfig.put("endpoints", Map.of("prometheus", Map.of()));
        }
        return managementConfig;
    }

    public List<Map<String, Object>> buildMicrometerConfig(Admin admin) {
        if (admin == null) {
            return null;
        }
        ArrayList<Map<String, Object>> micrometerConfig = new ArrayList<Map<String, Object>>();
        if (admin.jvmMetrics() != null) {
            LinkedHashMap<String, Object> micrometerJvmMetrics = new LinkedHashMap<String, Object>();
            micrometerJvmMetrics.put("type", "StandardBindersHook");
            micrometerJvmMetrics.put("config", Map.of("binderNames", admin.jvmMetrics()));
            micrometerConfig.add(micrometerJvmMetrics);
        }
        if (admin.commonTags() != null) {
            LinkedHashMap<String, Object> micrometerTags = new LinkedHashMap<String, Object>();
            micrometerTags.put("type", "CommonTagsHook");
            micrometerTags.put("config", Map.of("commonTags", admin.commonTags()));
            micrometerConfig.add(micrometerTags);
        }
        return micrometerConfig;
    }

    private boolean shouldEnablePrometheusEndpoint(Admin admin) {
        return admin.endpoints() != null && admin.endpoints().metrics();
    }
}

