/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.configadapter.builder;

import io.confluent.gateway.config.secret.FilePasswordProvider;
import io.confluent.gateway.config.secret.InlinePasswordProvider;
import io.confluent.gateway.config.secret.PasswordProvider;
import io.confluent.gateway.config.ssl.Keystore;
import io.confluent.gateway.config.ssl.Ssl;
import io.confluent.gateway.config.ssl.Truststore;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsConfigurationBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TlsConfigurationBuilder.class);

    public Map<String, Object> build(Ssl ssl) {
        LinkedHashMap<String, Object> tlsConfig = new LinkedHashMap<String, Object>();
        this.buildTrustConfiguration(ssl, tlsConfig);
        this.buildKeystoreConfiguration(ssl.keystore(), tlsConfig);
        return tlsConfig;
    }

    private void buildTrustConfiguration(Ssl ssl, Map<String, Object> tlsConfig) {
        if (ssl.ignoreTrust()) {
            tlsConfig.put("trust", Map.of("insecure", true));
            LOGGER.warn("Trust configured as insecure, truststore will not be used.");
        } else if (ssl.truststore() != null) {
            LinkedHashMap<String, Object> trustConfig = new LinkedHashMap<String, Object>();
            Truststore truststore = ssl.truststore();
            trustConfig.put("storeType", truststore.type());
            trustConfig.put("storeFile", truststore.location());
            if (truststore.password() != null) {
                trustConfig.put("storePassword", this.buildPasswordConfiguration(truststore.password()));
            }
            if (ssl.clientAuth() != null) {
                trustConfig.put("trustOptions", Map.of("clientAuth", ssl.clientAuth()));
            }
            tlsConfig.put("trust", trustConfig);
        }
    }

    private void buildKeystoreConfiguration(Keystore keystore, Map<String, Object> tlsConfig) {
        if (keystore != null) {
            LinkedHashMap<String, Object> keystoreConfig = new LinkedHashMap<String, Object>();
            keystoreConfig.put("storeType", keystore.type());
            keystoreConfig.put("storeFile", keystore.location());
            if (keystore.password() != null) {
                keystoreConfig.put("storePassword", this.buildPasswordConfiguration(keystore.password()));
            }
            if (keystore.keyPassword() != null) {
                keystoreConfig.put("keyPassword", this.buildPasswordConfiguration(keystore.keyPassword()));
            }
            tlsConfig.put("key", keystoreConfig);
        }
    }

    private Map<String, Object> buildPasswordConfiguration(PasswordProvider passwordProvider) {
        LinkedHashMap<String, Object> passwordConfig = new LinkedHashMap<String, Object>();
        if (passwordProvider instanceof FilePasswordProvider) {
            FilePasswordProvider fileProvider = (FilePasswordProvider)passwordProvider;
            passwordConfig.put("passwordFile", fileProvider.passwordFile());
        } else if (passwordProvider instanceof InlinePasswordProvider) {
            InlinePasswordProvider inlineProvider = (InlinePasswordProvider)passwordProvider;
            passwordConfig.put("password", inlineProvider.password());
        } else {
            throw new IllegalArgumentException("Unsupported PasswordProvider type: " + passwordProvider.getClass().getName());
        }
        return passwordConfig;
    }
}

