/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.license;

import io.confluent.gateway.license.DefaultLicenseKeyResolver;
import io.confluent.gateway.license.LicenseKeyResolver;
import io.confluent.license.License;
import java.io.File;
import java.nio.file.Files;
import java.security.PublicKey;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseVerifier.class);
    private PublicKey publicKey = null;

    public LicenseVerifier() {
        this(new DefaultLicenseKeyResolver());
    }

    public LicenseVerifier(LicenseKeyResolver licenseKeyResolver) {
        try {
            this.publicKey = licenseKeyResolver.resolve();
            if (this.publicKey != null) {
                LOGGER.info("Resolved public key algorithm: {}", (Object)this.publicKey.getAlgorithm());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to resolve public key", (Throwable)e);
        }
    }

    public List<JwtClaims> verify(File licenseFile) {
        List<JwtClaims> list;
        block10: {
            if (this.publicKey == null) {
                return List.of();
            }
            if (licenseFile == null || !licenseFile.exists()) {
                LOGGER.info("License file does not exist: {}", (Object)licenseFile);
                return List.of();
            }
            Stream<String> licenseTokens = Files.lines(licenseFile.toPath());
            try {
                List<String> tokens = licenseTokens.filter(StringUtils::isNotBlank).collect(Collectors.toList());
                LOGGER.info("Found {} license token(s)", (Object)tokens.size());
                list = this.verify(tokens);
                if (licenseTokens == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (licenseTokens != null) {
                        try {
                            licenseTokens.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to read license file: {}", (Object)licenseFile, (Object)e);
                    return List.of();
                }
            }
            licenseTokens.close();
        }
        return list;
    }

    public List<JwtClaims> verify(List<String> licenseTokens) {
        if (this.publicKey == null) {
            return List.of();
        }
        return licenseTokens.stream().filter(StringUtils::isNotBlank).filter(token -> !token.startsWith("#")).map(token -> {
            try {
                JwtClaims claims = License.verify((PublicKey)this.publicKey, (String)token);
                LOGGER.info("Found license token issued by {}", (Object)claims.getIssuer());
                return claims;
            }
            catch (Exception e) {
                LOGGER.info("Failed to parse and verify license token {}", e.getClass());
                LOGGER.debug("LicenseError: ", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

