/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.config.Configuration;
import io.kroxylicious.proxy.config.PluginAnnotationIntrospector;
import io.kroxylicious.proxy.config.PluginConfigTypeIdResolver;
import io.kroxylicious.proxy.config.PluginDiscoveryException;
import io.kroxylicious.proxy.config.PluginFactory;
import io.kroxylicious.proxy.config.PluginFactoryRegistry;
import io.kroxylicious.proxy.config.ServiceBasedPluginFactoryRegistry;
import io.kroxylicious.proxy.plugin.PluginImplConfig;
import io.kroxylicious.proxy.plugin.PluginImplName;
import io.kroxylicious.proxy.service.HostPort;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Iterator;
import java.util.List;

public class ConfigParser
implements PluginFactoryRegistry {
    private static final ObjectMapper MAPPER = ConfigParser.createObjectMapper();
    private static final ServiceBasedPluginFactoryRegistry pluginFactoryRegistry = new ServiceBasedPluginFactoryRegistry();

    public <T> PluginFactory<T> pluginFactory(Class<T> pluginClass) {
        return pluginFactoryRegistry.pluginFactory(pluginClass);
    }

    public Configuration parseConfiguration(String configuration) {
        try {
            return (Configuration)MAPPER.readValue(configuration, Configuration.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't parse configuration", e);
        }
    }

    public Configuration parseConfiguration(InputStream configuration) {
        try {
            return (Configuration)MAPPER.readValue(configuration, Configuration.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't parse configuration", e);
        }
    }

    public String toYaml(Configuration configuration) {
        try {
            return MAPPER.writeValueAsString((Object)configuration);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to encode configuration as YAML", e);
        }
    }

    public static ObjectMapper createObjectMapper() {
        return (ObjectMapper)ConfigParser.createBaseObjectMapper().registerModule((Module)new PluginModule()).setHandlerInstantiator((HandlerInstantiator)new PluginHandlerInstantiator());
    }

    public static ObjectMapper createBaseObjectMapper() {
        YAMLFactory yamlFactory = new YAMLFactory();
        yamlFactory.configure(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID, false);
        return new ObjectMapper((JsonFactory)yamlFactory).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new SimpleModule().addSerializer(HostPort.class, (JsonSerializer)new ToStringSerializer())).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).setVisibility(PropertyAccessor.CREATOR, JsonAutoDetect.Visibility.ANY).setConstructorDetector(ConstructorDetector.USE_PROPERTIES_BASED).enable(SerializationFeature.FAIL_ON_EMPTY_BEANS).enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(DeserializationFeature.FAIL_ON_MISSING_EXTERNAL_TYPE_ID_PROPERTY).enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION}).setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
    }

    private static class PluginModule
    extends SimpleModule {
        PluginModule() {
            super("Kroxylicious");
        }

        public void setupModule(Module.SetupContext context) {
            context.insertAnnotationIntrospector((AnnotationIntrospector)new PluginAnnotationIntrospector());
            super.setupModule(context);
        }
    }

    private static class PluginHandlerInstantiator
    extends HandlerInstantiator {
        private PluginHandlerInstantiator() {
        }

        @Nullable
        public JsonDeserializer<?> deserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> deserClass) {
            return null;
        }

        @Nullable
        public KeyDeserializer keyDeserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> keyDeserClass) {
            return null;
        }

        @Nullable
        public JsonSerializer<?> serializerInstance(SerializationConfig config, Annotated annotated, Class<?> serClass) {
            return null;
        }

        @Nullable
        public TypeResolverBuilder<?> typeResolverBuilderInstance(MapperConfig<?> config, Annotated annotated, Class<?> builderClass) {
            return null;
        }

        @Nullable
        public TypeIdResolver typeIdResolverInstance(MapperConfig<?> config, Annotated annotated, Class<?> resolverClass) {
            if (resolverClass == PluginConfigTypeIdResolver.class) {
                PluginImplName pluginImplName = null;
                if (annotated instanceof AnnotatedParameter) {
                    AnnotatedParameter ap = (AnnotatedParameter)annotated;
                    pluginImplName = this.pluginReferenceFromParameter(annotated, ap);
                } else if (annotated instanceof AnnotatedField) {
                    AnnotatedField af = (AnnotatedField)annotated;
                    pluginImplName = this.pluginReferenceFromField(annotated, af);
                }
                if (pluginImplName == null) {
                    throw new PluginDiscoveryException("Couldn't find @" + PluginImplName.class.getSimpleName() + " on member referred to by @" + PluginImplConfig.class.getSimpleName() + " on " + String.valueOf(annotated));
                }
                return PluginHandlerInstantiator.newResolver(pluginImplName.value());
            }
            return null;
        }

        @Nullable
        private PluginImplName pluginReferenceFromParameter(Annotated annotated, AnnotatedParameter ap) {
            PluginImplConfig pcAnno = (PluginImplConfig)ap.getAnnotation(PluginImplConfig.class);
            if (pcAnno == null) {
                throw new PluginDiscoveryException(String.valueOf(annotated) + " lacked the @" + PluginImplConfig.class.getName() + " annotation");
            }
            PluginImplName pluginImplName = this.findPluginReferenceAnnotation(ap.getOwner(), pcAnno.implNameProperty());
            return pluginImplName;
        }

        @Nullable
        private PluginImplName pluginReferenceFromField(Annotated annotated, AnnotatedField af) {
            AnnotatedConstructor ctor;
            PluginImplName pluginImplName = null;
            PluginImplConfig pcAnno = (PluginImplConfig)af.getAnnotation(PluginImplConfig.class);
            if (pcAnno == null) {
                throw new PluginDiscoveryException(String.valueOf(annotated) + " lacked the @" + PluginImplConfig.class.getName() + " annotation");
            }
            List ctors = ((AnnotatedClass)af.getTypeContext()).getConstructors();
            Iterator iterator = ctors.iterator();
            while (iterator.hasNext() && (pluginImplName = this.findPluginReferenceAnnotation((AnnotatedWithParams)(ctor = (AnnotatedConstructor)iterator.next()), pcAnno.implNameProperty())) == null) {
            }
            return pluginImplName;
        }

        private static PluginConfigTypeIdResolver newResolver(Class<?> pluginInterface) {
            PluginFactory<?> providersByName = pluginFactoryRegistry.pluginFactory(pluginInterface);
            return new PluginConfigTypeIdResolver(providersByName);
        }

        @Nullable
        private PluginImplName findPluginReferenceAnnotation(AnnotatedWithParams owner, String instanceNameProperty) {
            AnnotatedElement parameterOwner = owner.getAnnotated();
            if (parameterOwner instanceof Constructor) {
                Constructor ctor = (Constructor)parameterOwner;
                return PluginHandlerInstantiator.findPluginReferenceAnnotation(instanceNameProperty, ctor);
            }
            throw new IllegalStateException("Unsupported owner: " + String.valueOf(owner));
        }

        @Nullable
        private static PluginImplName findPluginReferenceAnnotation(String instanceNameProperty, Constructor<?> ctor) {
            Parameter[] parameters;
            for (Parameter parameter : parameters = ctor.getParameters()) {
                PluginImplName annotation;
                if (!instanceNameProperty.equals(parameter.getName()) || (annotation = parameter.getAnnotation(PluginImplName.class)) == null) continue;
                return annotation;
            }
            return null;
        }
    }
}

