/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.filter;

import io.kroxylicious.proxy.filter.FilterContext;
import io.kroxylicious.proxy.filter.RequestFilterResult;
import io.kroxylicious.proxy.filter.ResponseFilterResult;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;

public interface FilterInvoker {
    default public boolean shouldHandleRequest(ApiKeys apiKey, short apiVersion) {
        return false;
    }

    default public boolean shouldHandleResponse(ApiKeys apiKey, short apiVersion) {
        return false;
    }

    default public CompletionStage<RequestFilterResult> onRequest(ApiKeys apiKey, short apiVersion, RequestHeaderData header, ApiMessage body, FilterContext filterContext) {
        return filterContext.requestFilterResultBuilder().forward((ApiMessage)header, body).completed();
    }

    default public CompletionStage<ResponseFilterResult> onResponse(ApiKeys apiKey, short apiVersion, ResponseHeaderData header, ApiMessage body, FilterContext filterContext) {
        return filterContext.responseFilterResultBuilder().forward((ApiMessage)header, body).completed();
    }
}

