/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal;

import io.kroxylicious.proxy.filter.Filter;
import io.kroxylicious.proxy.frame.DecodedRequestFrame;
import io.kroxylicious.proxy.frame.DecodedResponseFrame;
import io.kroxylicious.proxy.internal.InternalResponseFrame;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ApiMessage;

public class InternalRequestFrame<B extends ApiMessage>
extends DecodedRequestFrame<B> {
    private final CompletableFuture<?> promise;
    private final Filter recipient;

    public InternalRequestFrame(short apiVersion, int correlationId, boolean decodeResponse, Filter recipient, CompletableFuture<?> promise, RequestHeaderData header, B body) {
        super(apiVersion, correlationId, decodeResponse, header, body);
        this.promise = promise;
        this.recipient = Objects.requireNonNull(recipient);
    }

    public Filter recipient() {
        return this.recipient;
    }

    public CompletableFuture<?> promise() {
        return this.promise;
    }

    @Override
    protected DecodedResponseFrame<? extends ApiMessage> createResponseFrame(ResponseHeaderData header, ApiMessage message) {
        return new InternalResponseFrame<ApiMessage>(this.recipient, this.apiVersion, this.correlationId, header, message, this.promise);
    }
}

