/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.filter.FilterAndInvoker;
import io.kroxylicious.proxy.filter.NetFilter;
import io.kroxylicious.proxy.frame.DecodedRequestFrame;
import io.kroxylicious.proxy.frame.DecodedResponseFrame;
import io.kroxylicious.proxy.frame.ResponseFrame;
import io.kroxylicious.proxy.internal.AuthenticationEvent;
import io.kroxylicious.proxy.internal.ClientSaslManager;
import io.kroxylicious.proxy.internal.FilterHandler;
import io.kroxylicious.proxy.internal.KafkaProxyBackendHandler;
import io.kroxylicious.proxy.internal.KafkaProxyExceptionMapper;
import io.kroxylicious.proxy.internal.ProxyChannelState;
import io.kroxylicious.proxy.internal.ProxyChannelStateMachine;
import io.kroxylicious.proxy.internal.SaslDecodePredicate;
import io.kroxylicious.proxy.internal.codec.CorrelationManager;
import io.kroxylicious.proxy.internal.codec.DecodePredicate;
import io.kroxylicious.proxy.internal.codec.KafkaMessageListener;
import io.kroxylicious.proxy.internal.codec.KafkaRequestEncoder;
import io.kroxylicious.proxy.internal.codec.KafkaResponseDecoder;
import io.kroxylicious.proxy.internal.metrics.MetricEmittingKafkaMessageListener;
import io.kroxylicious.proxy.internal.metrics.UpstreamPayloadSizeMetricRecordingKafkaMessageListener;
import io.kroxylicious.proxy.internal.net.EndpointBinding;
import io.kroxylicious.proxy.internal.util.Metrics;
import io.kroxylicious.proxy.model.VirtualClusterModel;
import io.kroxylicious.proxy.service.HostPort;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SniCompletionEvent;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.ApiVersionsResponseDataJsonConverter;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ApiMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProxyFrontendHandler
extends ChannelInboundHandlerAdapter
implements NetFilter.NetFilterContext {
    private static final String NET_FILTER_INVOKED_IN_WRONG_STATE = "NetFilterContext invoked in wrong session state";
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaProxyFrontendHandler.class);
    private static final ApiVersionsResponseData API_VERSIONS_RESPONSE;
    private final boolean logNetwork;
    private final boolean logFrames;
    private final VirtualClusterModel virtualClusterModel;
    private final EndpointBinding endpointBinding;
    private final NetFilter netFilter;
    private final SaslDecodePredicate dp;
    private final ProxyChannelStateMachine proxyChannelStateMachine;
    @Nullable
    private ChannelHandlerContext clientCtx;
    @Nullable
    List<Object> bufferedMsgs;
    private boolean pendingClientFlushes;
    @Nullable
    private AuthenticationEvent authentication;
    @Nullable
    private String sniHostname;
    private boolean pendingReadComplete = true;
    private boolean isClientBlocked = true;

    KafkaProxyFrontendHandler(NetFilter netFilter, SaslDecodePredicate dp, EndpointBinding endpointBinding, String clusterName) {
        this(netFilter, dp, endpointBinding, new ProxyChannelStateMachine(clusterName, endpointBinding.nodeId()));
    }

    KafkaProxyFrontendHandler(NetFilter netFilter, SaslDecodePredicate dp, EndpointBinding endpointBinding, ProxyChannelStateMachine proxyChannelStateMachine) {
        this.netFilter = netFilter;
        this.dp = dp;
        this.endpointBinding = endpointBinding;
        this.virtualClusterModel = endpointBinding.endpointGateway().virtualCluster();
        this.proxyChannelStateMachine = proxyChannelStateMachine;
        this.logNetwork = this.virtualClusterModel.isLogNetwork();
        this.logFrames = this.virtualClusterModel.isLogFrames();
    }

    public String toString() {
        return "KafkaProxyFrontendHandler{, clientCtx=" + String.valueOf(this.clientCtx) + ", proxyChannelState=" + this.proxyChannelStateMachine.currentState() + ", number of bufferedMsgs=" + (this.bufferedMsgs == null ? 0 : this.bufferedMsgs.size()) + ", pendingClientFlushes=" + this.pendingClientFlushes + ", authentication=" + String.valueOf(this.authentication) + ", sniHostname='" + this.sniHostname + "', pendingReadComplete=" + this.pendingReadComplete + ", isClientBlocked=" + this.isClientBlocked + "}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event instanceof SniCompletionEvent) {
            SniCompletionEvent sniCompletionEvent = (SniCompletionEvent)event;
            if (!sniCompletionEvent.isSuccess()) throw new IllegalStateException("SNI failed", sniCompletionEvent.cause());
            this.sniHostname = sniCompletionEvent.hostname();
        } else if (event instanceof AuthenticationEvent) {
            AuthenticationEvent authenticationEvent;
            this.authentication = authenticationEvent = (AuthenticationEvent)event;
        }
        super.userEventTriggered(ctx, event);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.clientCtx = ctx;
        this.proxyChannelStateMachine.onClientActive(this);
        super.channelActive(this.clientCtx);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        LOGGER.trace("INACTIVE on inbound {}", (Object)ctx.channel());
        this.proxyChannelStateMachine.onClientInactive();
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        if (ctx.channel().isWritable()) {
            this.proxyChannelStateMachine.onClientWritable();
        } else {
            this.proxyChannelStateMachine.onClientUnwritable();
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.proxyChannelStateMachine.onClientRequest(this.dp, msg);
    }

    void applyBackpressure() {
        if (this.clientCtx != null) {
            this.clientCtx.channel().config().setAutoRead(false);
        }
    }

    void relieveBackpressure() {
        if (this.clientCtx != null) {
            this.clientCtx.channel().config().setAutoRead(true);
        }
    }

    void inClientActive() {
        Channel clientChannel = this.clientCtx().channel();
        LOGGER.trace("{}: channelActive", (Object)clientChannel.id());
        clientChannel.config().setAutoRead(false);
        clientChannel.read();
    }

    void inApiVersions(DecodedRequestFrame<ApiVersionsRequestData> apiVersionsFrame) {
        this.writeApiVersionsResponse(this.clientCtx(), apiVersionsFrame);
        this.clientCtx().channel().read();
    }

    void inSelectingServer() {
        this.netFilter.selectServer(this);
        this.proxyChannelStateMachine.assertIsConnecting("NetFilter.selectServer() did not callback on NetFilterContext.initiateConnect(): filter='" + String.valueOf(this.netFilter) + "'");
    }

    private void writeApiVersionsResponse(ChannelHandlerContext ctx, DecodedRequestFrame<ApiVersionsRequestData> frame) {
        short apiVersion = frame.apiVersion();
        int correlationId = frame.correlationId();
        ResponseHeaderData header = new ResponseHeaderData().setCorrelationId(correlationId);
        LOGGER.debug("{}: Writing ApiVersions response", (Object)ctx.channel());
        ctx.writeAndFlush(new DecodedResponseFrame<ApiVersionsResponseData>(apiVersion, correlationId, header, API_VERSIONS_RESPONSE));
    }

    public void channelReadComplete(ChannelHandlerContext clientCtx) {
        this.proxyChannelStateMachine.clientReadComplete();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.proxyChannelStateMachine.onClientException(cause, this.endpointBinding.endpointGateway().getDownstreamSslContext().isPresent());
    }

    @Override
    public String clientHost() {
        ProxyChannelState.SelectingServer selectingServer = this.proxyChannelStateMachine.enforceInSelectingServer(NET_FILTER_INVOKED_IN_WRONG_STATE);
        if (selectingServer.haProxyMessage() != null) {
            return selectingServer.haProxyMessage().sourceAddress();
        }
        SocketAddress socketAddress = this.clientCtx().channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return inetSocketAddress.getAddress().getHostAddress();
        }
        return String.valueOf(socketAddress);
    }

    @Override
    public int clientPort() {
        ProxyChannelState.SelectingServer selectingServer = this.proxyChannelStateMachine.enforceInSelectingServer(NET_FILTER_INVOKED_IN_WRONG_STATE);
        if (selectingServer.haProxyMessage() != null) {
            return selectingServer.haProxyMessage().sourcePort();
        }
        SocketAddress socketAddress = this.clientCtx().channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return inetSocketAddress.getPort();
        }
        return -1;
    }

    @Override
    public SocketAddress srcAddress() {
        this.proxyChannelStateMachine.enforceInSelectingServer(NET_FILTER_INVOKED_IN_WRONG_STATE);
        return this.clientCtx().channel().remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        this.proxyChannelStateMachine.enforceInSelectingServer(NET_FILTER_INVOKED_IN_WRONG_STATE);
        return this.clientCtx().channel().localAddress();
    }

    @Override
    @Nullable
    public String authorizedId() {
        this.proxyChannelStateMachine.enforceInSelectingServer(NET_FILTER_INVOKED_IN_WRONG_STATE);
        return this.authentication != null ? this.authentication.authorizationId() : null;
    }

    @Override
    public String clientSoftwareName() {
        return this.proxyChannelStateMachine.enforceInSelectingServer(NET_FILTER_INVOKED_IN_WRONG_STATE).clientSoftwareName();
    }

    @Override
    public String clientSoftwareVersion() {
        return this.proxyChannelStateMachine.enforceInSelectingServer(NET_FILTER_INVOKED_IN_WRONG_STATE).clientSoftwareVersion();
    }

    @Override
    public String sniHostname() {
        this.proxyChannelStateMachine.enforceInSelectingServer(NET_FILTER_INVOKED_IN_WRONG_STATE);
        return this.sniHostname;
    }

    @Override
    public void initiateConnect(HostPort remote, List<FilterAndInvoker> filters) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: Connecting to backend broker {} using filters {}", new Object[]{this.clientCtx().channel().id(), remote, filters});
        }
        this.proxyChannelStateMachine.onNetFilterInitiateConnect(remote, filters, this.virtualClusterModel, this.netFilter);
    }

    void inConnecting(HostPort remote, List<FilterAndInvoker> filters, KafkaProxyBackendHandler backendHandler) {
        Channel inboundChannel = this.clientCtx().channel();
        Bootstrap bootstrap = this.configureBootstrap(backendHandler, inboundChannel);
        LOGGER.trace("Connecting to outbound {}", (Object)remote);
        ChannelFuture serverTcpConnectFuture = this.initConnection(remote.host(), remote.port(), bootstrap);
        Channel outboundChannel = serverTcpConnectFuture.channel();
        ChannelPipeline pipeline = outboundChannel.pipeline();
        CorrelationManager correlationManager = new CorrelationManager();
        if (this.logFrames) {
            pipeline.addFirst("frameLogger", (ChannelHandler)new LoggingHandler("io.kroxylicious.proxy.internal.UpstreamFrameLogger", LogLevel.INFO));
        }
        this.addFiltersToPipeline(filters, pipeline, inboundChannel);
        MetricEmittingKafkaMessageListener encoderListener = this.buildMetricsMessageListenerForEncode();
        KafkaMessageListener decoderListener = this.buildMetricsMessageListenerForDecode();
        pipeline.addFirst("responseDecoder", (ChannelHandler)new KafkaResponseDecoder(correlationManager, this.virtualClusterModel.socketFrameMaxSizeBytes(), decoderListener));
        pipeline.addFirst("requestEncoder", (ChannelHandler)new KafkaRequestEncoder(correlationManager, encoderListener));
        if (this.logNetwork) {
            pipeline.addFirst("networkLogger", (ChannelHandler)new LoggingHandler("io.kroxylicious.proxy.internal.UpstreamNetworkLogger", LogLevel.INFO));
        }
        this.virtualClusterModel.getUpstreamSslContext().ifPresent(sslContext -> {
            SslHandler handler = sslContext.newHandler(outboundChannel.alloc(), remote.host(), remote.port());
            pipeline.addFirst("ssl", (ChannelHandler)handler);
        });
        LOGGER.debug("Configured broker channel pipeline: {}", (Object)pipeline);
        serverTcpConnectFuture.addListener(future -> {
            if (future.isSuccess()) {
                LOGGER.trace("{}: Outbound connected", (Object)this.clientCtx().channel().id());
                this.dp.setDelegate(DecodePredicate.forFilters(filters));
            } else {
                this.proxyChannelStateMachine.onServerException(future.cause());
            }
        });
    }

    private MetricEmittingKafkaMessageListener buildMetricsMessageListenerForEncode() {
        String clusterName = this.virtualClusterModel.getClusterName();
        Integer nodeId = this.endpointBinding.nodeId();
        Meter.MeterProvider<Counter> proxyToServerMessageCounterProvider = Metrics.proxyToServerMessageCounterProvider(clusterName, nodeId);
        Meter.MeterProvider<DistributionSummary> proxyToServerMessageSizeDistributionProvider = Metrics.proxyToServerMessageSizeDistributionProvider(clusterName, nodeId);
        return new MetricEmittingKafkaMessageListener(proxyToServerMessageCounterProvider, proxyToServerMessageSizeDistributionProvider);
    }

    private KafkaMessageListener buildMetricsMessageListenerForDecode() {
        String clusterName = this.virtualClusterModel.getClusterName();
        Integer nodeId = this.endpointBinding.nodeId();
        Meter.MeterProvider<Counter> serverToProxyMessageCounterProvider = Metrics.serverToProxyMessageCounterProvider(clusterName, nodeId);
        Meter.MeterProvider<DistributionSummary> serverToProxyMessageSizeDistributionProvider = Metrics.serverToProxyMessageSizeDistributionProvider(clusterName, nodeId);
        return KafkaMessageListener.chainOf(new MetricEmittingKafkaMessageListener(serverToProxyMessageCounterProvider, serverToProxyMessageSizeDistributionProvider), this.getDeprecatedUpstreamMessageMetrics(clusterName));
    }

    private KafkaMessageListener getDeprecatedUpstreamMessageMetrics(String clusterName) {
        return new UpstreamPayloadSizeMetricRecordingKafkaMessageListener(Metrics.payloadSizeBytesDownstreamSummary(clusterName));
    }

    Bootstrap configureBootstrap(KafkaProxyBackendHandler backendHandler, Channel inboundChannel) {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)inboundChannel.eventLoop())).channel(inboundChannel.getClass())).handler((ChannelHandler)backendHandler)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true);
        return bootstrap;
    }

    ChannelFuture initConnection(String remoteHost, int remotePort, Bootstrap bootstrap) {
        return bootstrap.connect(remoteHost, remotePort);
    }

    void inForwarding() {
        if (this.bufferedMsgs != null) {
            for (Object bufferedMsg : this.bufferedMsgs) {
                this.proxyChannelStateMachine.messageFromClient(bufferedMsg);
            }
            this.bufferedMsgs = null;
        }
        if (this.pendingReadComplete) {
            this.pendingReadComplete = false;
            this.channelReadComplete(this.clientCtx);
        }
        if (this.isClientBlocked) {
            this.unblockClient();
        }
    }

    void inClosed(@Nullable Throwable errorCodeEx) {
        Channel inboundChannel = this.clientCtx().channel();
        if (inboundChannel.isActive()) {
            ResponseFrame msg = null;
            if (errorCodeEx != null) {
                msg = this.errorResponse(errorCodeEx);
            }
            if (msg == null) {
                msg = Unpooled.EMPTY_BUFFER;
            }
            inboundChannel.writeAndFlush((Object)msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    void forwardToClient(Object msg) {
        Channel inboundChannel = this.clientCtx().channel();
        if (inboundChannel.isWritable()) {
            inboundChannel.write(msg, this.clientCtx().voidPromise());
            this.pendingClientFlushes = true;
        } else {
            inboundChannel.writeAndFlush(msg, this.clientCtx().voidPromise());
            this.pendingClientFlushes = false;
        }
    }

    void flushToClient() {
        Channel inboundChannel = this.clientCtx().channel();
        if (this.pendingClientFlushes) {
            this.pendingClientFlushes = false;
            inboundChannel.flush();
        }
        if (!inboundChannel.isWritable()) {
            this.proxyChannelStateMachine.onClientUnwritable();
        }
    }

    void bufferMsg(Object msg) {
        if (this.bufferedMsgs == null) {
            this.bufferedMsgs = new ArrayList<Object>();
        }
        this.bufferedMsgs.add(msg);
    }

    private void addFiltersToPipeline(List<FilterAndInvoker> filters, ChannelPipeline pipeline, Channel inboundChannel) {
        int num = 0;
        ClientSaslManager clientSaslManager = new ClientSaslManager();
        for (FilterAndInvoker protocolFilter : filters) {
            String handlerName = "filter-" + ++num + "-" + protocolFilter.filterName();
            pipeline.addFirst(handlerName, (ChannelHandler)new FilterHandler(protocolFilter, 20000L, this.sniHostname, this.virtualClusterModel, inboundChannel, clientSaslManager));
        }
    }

    private void unblockClient() {
        this.isClientBlocked = false;
        Channel inboundChannel = this.clientCtx().channel();
        inboundChannel.config().setAutoRead(true);
        this.proxyChannelStateMachine.onClientWritable();
    }

    private ChannelHandlerContext clientCtx() {
        return Objects.requireNonNull(this.clientCtx, "clientCtx was null while in state " + this.proxyChannelStateMachine.currentState());
    }

    private static ResponseFrame buildErrorResponseFrame(DecodedRequestFrame<?> triggerFrame, Throwable error) {
        ApiMessage responseData = KafkaProxyExceptionMapper.errorResponseMessage(triggerFrame, error);
        ResponseHeaderData responseHeaderData = new ResponseHeaderData();
        responseHeaderData.setCorrelationId(triggerFrame.correlationId());
        return new DecodedResponseFrame<ApiMessage>(triggerFrame.apiVersion(), triggerFrame.correlationId(), responseHeaderData, responseData);
    }

    @Nullable
    private ResponseFrame errorResponse(@Nullable Throwable errorCodeEx) {
        ResponseFrame errorResponse;
        Object triggerMsg;
        Object object = triggerMsg = this.bufferedMsgs != null && !this.bufferedMsgs.isEmpty() ? this.bufferedMsgs.get(0) : null;
        if (errorCodeEx != null && triggerMsg instanceof DecodedRequestFrame) {
            DecodedRequestFrame triggerFrame = (DecodedRequestFrame)triggerMsg;
            errorResponse = KafkaProxyFrontendHandler.buildErrorResponseFrame(triggerFrame, errorCodeEx);
        } else {
            errorResponse = null;
        }
        return errorResponse;
    }

    static {
        ObjectMapper objectMapper = new ObjectMapper();
        try (InputStream parser = KafkaProxyFrontendHandler.class.getResourceAsStream("/ApiVersions-3.2.json");){
            API_VERSIONS_RESPONSE = ApiVersionsResponseDataJsonConverter.read((JsonNode)objectMapper.readTree(parser), (short)3);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

