/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.frame.DecodedRequestFrame;
import io.kroxylicious.proxy.service.HostPort;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import java.util.Objects;
import org.apache.kafka.common.message.ApiVersionsRequestData;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
interface ProxyChannelState {

    public record Closed() implements ProxyChannelState
    {
    }

    public static final class Forwarding
    implements ProxyChannelState {
        @Nullable
        private final HAProxyMessage haProxyMessage;
        @Nullable
        private final String clientSoftwareName;
        @Nullable
        private final String clientSoftwareVersion;

        Forwarding(@Nullable HAProxyMessage haProxyMessage, @Nullable String clientSoftwareName, @Nullable String clientSoftwareVersion) {
            this.haProxyMessage = haProxyMessage;
            this.clientSoftwareName = clientSoftwareName;
            this.clientSoftwareVersion = clientSoftwareVersion;
        }

        @Nullable
        public HAProxyMessage haProxyMessage() {
            return this.haProxyMessage;
        }

        @Nullable
        public String clientSoftwareName() {
            return this.clientSoftwareName;
        }

        @Nullable
        public String clientSoftwareVersion() {
            return this.clientSoftwareVersion;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Forwarding that = (Forwarding)obj;
            return Objects.equals(this.haProxyMessage, that.haProxyMessage) && Objects.equals(this.clientSoftwareName, that.clientSoftwareName) && Objects.equals(this.clientSoftwareVersion, that.clientSoftwareVersion);
        }

        public int hashCode() {
            return Objects.hash(this.haProxyMessage, this.clientSoftwareName, this.clientSoftwareVersion);
        }

        public String toString() {
            return "Forwarding[haProxyMessage=" + String.valueOf(this.haProxyMessage) + ", clientSoftwareName=" + this.clientSoftwareName + ", clientSoftwareVersion=" + this.clientSoftwareVersion + "]";
        }
    }

    public record Connecting(@Nullable HAProxyMessage haProxyMessage, @Nullable String clientSoftwareName, @Nullable String clientSoftwareVersion, HostPort remote) implements ProxyChannelState
    {
        public Forwarding toForwarding() {
            return new Forwarding(this.haProxyMessage, this.clientSoftwareName, this.clientSoftwareVersion);
        }
    }

    public record SelectingServer(@Nullable HAProxyMessage haProxyMessage, @Nullable String clientSoftwareName, @Nullable String clientSoftwareVersion) implements ProxyChannelState
    {
        public Connecting toConnecting(HostPort remote) {
            return new Connecting(this.haProxyMessage, this.clientSoftwareName, this.clientSoftwareVersion, remote);
        }
    }

    public record ApiVersions(@Nullable HAProxyMessage haProxyMessage, @Nullable String clientSoftwareName, @Nullable String clientSoftwareVersion) implements ProxyChannelState
    {
        public SelectingServer toSelectingServer() {
            return new SelectingServer(this.haProxyMessage, this.clientSoftwareName, this.clientSoftwareVersion);
        }
    }

    public record HaProxy(HAProxyMessage haProxyMessage) implements ProxyChannelState
    {
        public ApiVersions toApiVersions(DecodedRequestFrame<ApiVersionsRequestData> apiVersionsFrame) {
            String clientSoftwareName = ((ApiVersionsRequestData)apiVersionsFrame.body()).clientSoftwareName();
            String clientSoftwareVersion = ((ApiVersionsRequestData)apiVersionsFrame.body()).clientSoftwareVersion();
            return new ApiVersions(this.haProxyMessage, clientSoftwareName, clientSoftwareVersion);
        }

        public SelectingServer toSelectingServer(@Nullable DecodedRequestFrame<ApiVersionsRequestData> apiVersionsFrame) {
            return new SelectingServer(this.haProxyMessage, apiVersionsFrame == null ? null : ((ApiVersionsRequestData)apiVersionsFrame.body()).clientSoftwareName(), apiVersionsFrame == null ? null : ((ApiVersionsRequestData)apiVersionsFrame.body()).clientSoftwareVersion());
        }
    }

    public record ClientActive() implements ProxyChannelState
    {
        public HaProxy toHaProxy(HAProxyMessage haProxyMessage) {
            return new HaProxy(haProxyMessage);
        }

        public ApiVersions toApiVersions(DecodedRequestFrame<ApiVersionsRequestData> apiVersionsFrame) {
            String clientSoftwareName = ((ApiVersionsRequestData)apiVersionsFrame.body()).clientSoftwareName();
            String clientSoftwareVersion = ((ApiVersionsRequestData)apiVersionsFrame.body()).clientSoftwareVersion();
            return new ApiVersions(null, clientSoftwareName, clientSoftwareVersion);
        }

        public SelectingServer toSelectingServer(@Nullable DecodedRequestFrame<ApiVersionsRequestData> apiVersionsFrame) {
            return new SelectingServer(null, apiVersionsFrame == null ? null : ((ApiVersionsRequestData)apiVersionsFrame.body()).clientSoftwareName(), apiVersionsFrame == null ? null : ((ApiVersionsRequestData)apiVersionsFrame.body()).clientSoftwareVersion());
        }
    }

    public record Startup() implements ProxyChannelState
    {
        public static final Startup STARTING_STATE = new Startup();

        public ClientActive toClientActive() {
            return new ClientActive();
        }
    }
}

