/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.config;

import io.kroxylicious.proxy.config.Configuration;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Feature {
    TEST_ONLY_CONFIGURATION{

        @Override
        public Optional<String> maybeWarning(boolean enabled) {
            if (enabled) {
                return Optional.of("test-only configuration for proxy will be loaded. these configurations are unsupported and have no compatibility guarantees, they could be removed or changed at any time");
            }
            return Optional.empty();
        }

        @Override
        public Stream<String> supports(Configuration configuration, boolean enabled) {
            Optional<Map<String, Object>> development = configuration.development();
            if (development.isPresent() && !development.get().isEmpty() && !enabled) {
                return Stream.of("test-only configuration for proxy present, but loading test-only configuration not enabled");
            }
            return Stream.empty();
        }
    };


    public abstract Stream<String> supports(Configuration var1, boolean var2);

    public boolean enabledByDefault() {
        return false;
    }

    public abstract Optional<String> maybeWarning(boolean var1);
}

