/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.metrics;

import io.kroxylicious.proxy.frame.DecodedRequestFrame;
import io.kroxylicious.proxy.frame.Frame;
import io.kroxylicious.proxy.internal.codec.KafkaMessageListener;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import java.util.Objects;
import org.apache.kafka.common.protocol.ApiKeys;

@Deprecated(since="0.13.0", forRemoval=true)
public class DownstreamMessageCountingKafkaMessageListener
implements KafkaMessageListener {
    private final Counter messageCounter;
    private final Counter decodedMessagesCounter;
    private final Meter.MeterProvider<DistributionSummary> messageSizeDistributionProvider;

    public DownstreamMessageCountingKafkaMessageListener(Counter messageCounter, Counter decodedMessageCounter, Meter.MeterProvider<DistributionSummary> decodedMessageSizeProvider) {
        this.messageCounter = Objects.requireNonNull(messageCounter);
        this.decodedMessagesCounter = Objects.requireNonNull(decodedMessageCounter);
        this.messageSizeDistributionProvider = Objects.requireNonNull(decodedMessageSizeProvider);
    }

    @Override
    public void onMessage(Frame frame, int wireLength) {
        this.messageCounter.increment();
        if (frame instanceof DecodedRequestFrame) {
            DecodedRequestFrame decodedRequestFrame = (DecodedRequestFrame)frame;
            this.decodedMessagesCounter.increment();
            int size = wireLength - 4;
            ApiKeys apiKey = decodedRequestFrame.apiKey();
            short apiVersion = decodedRequestFrame.apiVersion();
            ((DistributionSummary)this.messageSizeDistributionProvider.withTags(new String[]{"ApiKey", apiKey.name(), "ApiVersion", String.valueOf(apiVersion)})).record((double)size);
        }
    }
}

