/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.metrics;

import io.kroxylicious.proxy.frame.Frame;
import io.kroxylicious.proxy.internal.codec.KafkaMessageListener;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import java.util.Objects;
import org.apache.kafka.common.protocol.ApiKeys;

public class MetricEmittingKafkaMessageListener
implements KafkaMessageListener {
    private final Meter.MeterProvider<Counter> messageCounterProvider;
    private final Meter.MeterProvider<DistributionSummary> messageSizeProvider;

    public MetricEmittingKafkaMessageListener(Meter.MeterProvider<Counter> messageCounterProvider, Meter.MeterProvider<DistributionSummary> messageSizeProvider) {
        this.messageCounterProvider = Objects.requireNonNull(messageCounterProvider);
        this.messageSizeProvider = Objects.requireNonNull(messageSizeProvider);
    }

    @Override
    public void onMessage(Frame frame, int wireLength) {
        ApiKeys apiKey = ApiKeys.forId((int)frame.apiKeyId());
        short version = frame.apiVersion();
        boolean decoded = frame.isDecoded();
        ((Counter)this.messageCounterProvider.withTags(new String[]{"decoded", Boolean.toString(decoded), "api_key", apiKey.name(), "api_version", Short.toString(version)})).increment();
        ((DistributionSummary)this.messageSizeProvider.withTags(new String[]{"decoded", Boolean.toString(decoded), "api_key", apiKey.name(), "api_version", Short.toString(version)})).record((double)wireLength);
    }
}

