/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.micrometer;

import com.fasterxml.jackson.annotation.JsonCreator;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.micrometer.MicrometerConfigurationHook;
import io.kroxylicious.proxy.micrometer.MicrometerConfigurationHookService;
import io.kroxylicious.proxy.plugin.Plugin;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(configType=CommonTagsHookConfig.class)
public class CommonTagsHook
implements MicrometerConfigurationHookService<CommonTagsHookConfig> {
    private static final Logger log = LoggerFactory.getLogger(CommonTagsHook.class);

    @Override
    public MicrometerConfigurationHook build(CommonTagsHookConfig config) {
        return new Hook(config);
    }

    private static class Hook
    implements MicrometerConfigurationHook {
        private final CommonTagsHookConfig config;

        private Hook(CommonTagsHookConfig config) {
            if (config == null) {
                throw new IllegalArgumentException("config must be non null");
            }
            this.config = config;
        }

        @Override
        public void configure(MeterRegistry targetRegistry) {
            List tags = this.config.commonTags.entrySet().stream().map(entry -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList());
            targetRegistry.config().commonTags(tags);
            log.info("configured micrometer registry with tags: {}", tags);
        }
    }

    public static class CommonTagsHookConfig {
        private final Map<String, String> commonTags;

        @JsonCreator
        public CommonTagsHookConfig(@Nullable Map<String, String> commonTags) {
            this.commonTags = commonTags == null ? Map.of() : commonTags;
        }
    }
}

