/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.micrometer;

import com.fasterxml.jackson.annotation.JsonCreator;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.micrometer.MicrometerConfigurationHook;
import io.kroxylicious.proxy.micrometer.MicrometerConfigurationHookService;
import io.kroxylicious.proxy.plugin.Plugin;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.distribution.pause.ClockDriftPauseDetector;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(configType=PauseDetectorHookConfig.class)
public class PauseDetectorHook
implements MicrometerConfigurationHookService<PauseDetectorHookConfig> {
    private static final Logger log = LoggerFactory.getLogger(PauseDetectorHook.class);

    @Override
    public MicrometerConfigurationHook build(PauseDetectorHookConfig config) {
        return new Hook(config);
    }

    private record Hook(PauseDetectorHookConfig config) implements MicrometerConfigurationHook
    {
        private Hook {
            Objects.requireNonNull(config, "config must be non null");
        }

        @Override
        public void configure(MeterRegistry targetRegistry) {
            ClockDriftPauseDetector pauseDetector = new ClockDriftPauseDetector(this.config.getSleepInterval(), this.config.getPauseThreshold());
            targetRegistry.config().pauseDetector((PauseDetector)pauseDetector);
            log.info("Configured pause detector on micrometer registry with sleep interval: {}ms and pause threshold: {}ms", (Object)this.config.getSleepInterval().toMillis(), (Object)this.config.getPauseThreshold().toMillis());
        }
    }

    public static class PauseDetectorHookConfig {
        static final long DEFAULT_SLEEP_INTERVAL_MS = 100L;
        static final long DEFAULT_PAUSE_THRESHOLD_MS = 100L;
        private final Duration sleepIntervalMs;
        private final Duration pauseThresholdMs;

        @JsonCreator
        @ConstructorProperties(value={"sleepIntervalMs", "pauseThresholdMs"})
        public PauseDetectorHookConfig(@Nullable Long sleepIntervalMs, @Nullable Long pauseThresholdMs) {
            this.sleepIntervalMs = Duration.ofMillis(sleepIntervalMs != null ? sleepIntervalMs : 100L);
            this.pauseThresholdMs = Duration.ofMillis(pauseThresholdMs != null ? pauseThresholdMs : 100L);
        }

        public Duration getSleepInterval() {
            return this.sleepIntervalMs;
        }

        public Duration getPauseThreshold() {
            return this.pauseThresholdMs;
        }
    }
}

