/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.micrometer;

import com.fasterxml.jackson.annotation.JsonCreator;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.micrometer.MicrometerConfigurationHook;
import io.kroxylicious.proxy.micrometer.MicrometerConfigurationHookService;
import io.kroxylicious.proxy.plugin.Plugin;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmCompilationMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmInfoMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(configType=StandardBindersHookConfig.class)
public class StandardBindersHook
implements MicrometerConfigurationHookService<StandardBindersHookConfig> {
    @Override
    public MicrometerConfigurationHook build(StandardBindersHookConfig config) {
        return new Hook(config);
    }

    static class Hook
    implements MicrometerConfigurationHook {
        private static final Logger log = LoggerFactory.getLogger(StandardBindersHook.class);
        private final StandardBindersHookConfig config;
        private final List<AutoCloseable> closeableBinders = new CopyOnWriteArrayList<AutoCloseable>();

        Hook(StandardBindersHookConfig config) {
            if (config == null) {
                throw new IllegalArgumentException("config should be non-null");
            }
            this.config = config;
        }

        @Override
        public void configure(MeterRegistry targetRegistry) {
            for (String binderName : this.config.binderNames) {
                MeterBinder binder = this.getBinder(binderName);
                binder.bindTo(targetRegistry);
                if (binder instanceof AutoCloseable) {
                    AutoCloseable closeable = (AutoCloseable)binder;
                    this.closeableBinders.add(closeable);
                }
                log.info("bound {} to micrometer registry", (Object)binderName);
            }
        }

        @Override
        public void close() {
            this.closeableBinders.forEach(closeable -> {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    log.warn("Ignoring exception whilst closing standard binder {}", closeable.getClass(), (Object)e);
                }
            });
        }

        protected MeterBinder getBinder(String binderName) {
            return switch (binderName) {
                case "UptimeMetrics" -> new UptimeMetrics();
                case "ProcessorMetrics" -> new ProcessorMetrics();
                case "FileDescriptorMetrics" -> new FileDescriptorMetrics();
                case "ClassLoaderMetrics" -> new ClassLoaderMetrics();
                case "JvmCompilationMetrics" -> new JvmCompilationMetrics();
                case "JvmGcMetrics" -> new JvmGcMetrics();
                case "JvmHeapPressureMetrics" -> new JvmHeapPressureMetrics();
                case "JvmInfoMetrics" -> new JvmInfoMetrics();
                case "JvmMemoryMetrics" -> new JvmMemoryMetrics();
                case "JvmThreadMetrics" -> new JvmThreadMetrics();
                default -> throw new IllegalArgumentException("no binder available for " + binderName);
            };
        }
    }

    public static class StandardBindersHookConfig {
        private final List<String> binderNames;

        @JsonCreator
        public StandardBindersHookConfig(@Nullable List<String> binderNames) {
            this.binderNames = binderNames == null ? List.of() : binderNames;
        }
    }
}

