/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.model;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.netty.handler.ssl.CipherSuiteFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DenyCipherSuiteFilter
implements CipherSuiteFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DenyCipherSuiteFilter.class);
    private final Set<String> deniedCiphers;

    public DenyCipherSuiteFilter(@Nullable Set<String> deniedCiphers) {
        this.deniedCiphers = deniedCiphers == null ? new HashSet() : deniedCiphers;
    }

    public String[] filterCipherSuites(Iterable<String> ciphers, List<String> defaultCiphers, Set<String> supportedCiphers) {
        List<String> actualCiphers = ciphers == null || !ciphers.iterator().hasNext() ? defaultCiphers : ciphers;
        StreamSupport.stream(actualCiphers.spliterator(), false).filter(Predicate.not(supportedCiphers::contains)).forEach(unsupportedCipher -> LOGGER.warn("Ignoring allowed cipher '{}' as it is not recognized by this platform (supported ciphers: {})", unsupportedCipher, (Object)supportedCiphers));
        this.deniedCiphers.stream().filter(Predicate.not(supportedCiphers::contains)).forEach(unsupportedCipher -> LOGGER.warn("Ignoring denied cipher '{}' as it is not recognized by this platform (supported ciphers: {})", unsupportedCipher, (Object)supportedCiphers));
        return StreamSupport.stream(actualCiphers.spliterator(), false).filter(supportedCiphers::contains).filter(Predicate.not(this.deniedCiphers::contains)).toList().toArray(new String[0]);
    }
}

