/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.model;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.config.IllegalConfigurationException;
import io.kroxylicious.proxy.config.NamedFilterDefinition;
import io.kroxylicious.proxy.config.TargetCluster;
import io.kroxylicious.proxy.config.tls.AllowDeny;
import io.kroxylicious.proxy.config.tls.NettyKeyProvider;
import io.kroxylicious.proxy.config.tls.NettyTrustProvider;
import io.kroxylicious.proxy.config.tls.PlatformTrustProvider;
import io.kroxylicious.proxy.config.tls.SslContextBuildException;
import io.kroxylicious.proxy.config.tls.Tls;
import io.kroxylicious.proxy.config.tls.TrustOptions;
import io.kroxylicious.proxy.config.tls.TrustProvider;
import io.kroxylicious.proxy.internal.net.EndpointGateway;
import io.kroxylicious.proxy.internal.util.StableKroxyliciousLinkGenerator;
import io.kroxylicious.proxy.model.DenyCipherSuiteFilter;
import io.kroxylicious.proxy.service.HostPort;
import io.kroxylicious.proxy.service.NodeIdentificationStrategy;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.UncheckedIOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualClusterModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualClusterModel.class);
    public static final int DEFAULT_SOCKET_FRAME_MAX_SIZE_BYTES = 0x6400000;
    private final String clusterName;
    private final TargetCluster targetCluster;
    private final boolean logNetwork;
    private final boolean logFrames;
    private final Map<String, VirtualClusterGatewayModel> gateways = new HashMap<String, VirtualClusterGatewayModel>();
    private final List<NamedFilterDefinition> filters;
    private final Optional<SslContext> upstreamSslContext;

    public VirtualClusterModel(String clusterName, TargetCluster targetCluster, boolean logNetwork, boolean logFrames, List<NamedFilterDefinition> filters) {
        this.clusterName = Objects.requireNonNull(clusterName);
        this.targetCluster = Objects.requireNonNull(targetCluster);
        this.logNetwork = logNetwork;
        this.logFrames = logFrames;
        this.filters = filters;
        this.upstreamSslContext = this.buildUpstreamSslContext();
    }

    public void logVirtualClusterSummary() {
        List<HostPort> upstreamHostPort = this.targetCluster.bootstrapServersList();
        String upstreamTlsSummary = VirtualClusterModel.generateTlsSummary(this.targetCluster.tls());
        LOGGER.info("Virtual Cluster '{}' - gateway summary", (Object)this.clusterName);
        this.gateways.forEach((name, gateway) -> {
            HostPort downstreamBootstrap = gateway.getClusterBootstrapAddress();
            String downstreamTlsSummary = VirtualClusterModel.generateTlsSummary(gateway.getTls());
            LOGGER.info("Gateway: {}, Downstream {}{} => Upstream {}{}", new Object[]{name, downstreamBootstrap, downstreamTlsSummary, upstreamHostPort, upstreamTlsSummary});
        });
    }

    private static String generateTlsSummary(Optional<Tls> tlsToSummarize) {
        String tls = tlsToSummarize.map(t -> Optional.ofNullable(t.trust()).map(TrustProvider::trustOptions).map(TrustOptions::toString).orElse("-")).map(options -> " (TLS: " + options + ") ").orElse("");
        String cipherSuitesAllowed = tlsToSummarize.map(t -> Optional.ofNullable(t.cipherSuites()).map(AllowDeny::allowed).orElse(Collections.emptyList())).map(allowedCiphers -> " (Allowed Ciphers: " + String.valueOf(allowedCiphers) + ")").orElse("");
        String cipherSuitesDenied = tlsToSummarize.map(t -> Optional.ofNullable(t.cipherSuites()).map(AllowDeny::denied).orElse(Collections.emptySet())).map(deniedCiphers -> " (Denied Ciphers: " + String.valueOf(deniedCiphers) + ")").orElse("");
        String protocolsAllowed = tlsToSummarize.map(t -> Optional.ofNullable(t.protocols()).map(AllowDeny::allowed).orElse(Collections.emptyList())).map(protocols -> " (Allowed Protocols: " + String.valueOf(protocols) + ")").orElse("");
        String protocolsDenied = tlsToSummarize.map(t -> Optional.ofNullable(t.protocols()).map(AllowDeny::denied).orElse(Collections.emptySet())).map(protocols -> " (Denied Protocols: " + String.valueOf(protocols) + ")").orElse("");
        return tls + cipherSuitesAllowed + cipherSuitesDenied + protocolsAllowed + protocolsDenied;
    }

    public void addGateway(String name, NodeIdentificationStrategy nodeIdentificationStrategy, Optional<Tls> tls) {
        this.gateways.put(name, new VirtualClusterGatewayModel(this, nodeIdentificationStrategy, tls, name));
    }

    public TargetCluster targetCluster() {
        return this.targetCluster;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public boolean isLogNetwork() {
        return this.logNetwork;
    }

    public boolean isLogFrames() {
        return this.logFrames;
    }

    public int socketFrameMaxSizeBytes() {
        return 0x6400000;
    }

    public String toString() {
        return "VirtualClusterModel{clusterName='" + this.clusterName + "', targetCluster=" + String.valueOf(this.targetCluster) + ", gateways=" + String.valueOf(this.gateways) + ", logNetwork=" + this.logNetwork + ", logFrames=" + this.logFrames + ", upstreamSslContext=" + String.valueOf(this.upstreamSslContext) + "}";
    }

    public Optional<SslContext> getUpstreamSslContext() {
        return this.upstreamSslContext;
    }

    private static NettyTrustProvider configureTrustProvider(Tls tlsConfiguration) {
        TrustProvider trustProvider = Optional.ofNullable(tlsConfiguration.trust()).orElse((TrustProvider)PlatformTrustProvider.INSTANCE);
        return new NettyTrustProvider(trustProvider);
    }

    private Optional<SslContext> buildUpstreamSslContext() {
        return this.targetCluster.tls().map(targetClusterTls -> {
            try {
                SslContextBuilder sslContextBuilder = Optional.ofNullable(targetClusterTls.key()).map(NettyKeyProvider::new).map(NettyKeyProvider::forClient).orElse(SslContextBuilder.forClient());
                VirtualClusterModel.configureCipherSuites(sslContextBuilder, targetClusterTls);
                VirtualClusterModel.configureEnabledProtocols(sslContextBuilder, targetClusterTls);
                Optional.ofNullable(targetClusterTls.trust()).map(TrustProvider::trustOptions).filter(Predicate.not(TrustOptions::forClient)).ifPresent(to -> {
                    throw new IllegalConfigurationException("Cannot apply trust options " + String.valueOf(to) + " to upstream (client) TLS.)");
                });
                SslContextBuilder withTrust = VirtualClusterModel.configureTrustProvider(targetClusterTls).apply(sslContextBuilder);
                return withTrust.build();
            }
            catch (SSLException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private static void configureCipherSuites(SslContextBuilder sslContextBuilder, Tls tlsConfiguration) {
        Optional.ofNullable(tlsConfiguration.cipherSuites()).ifPresent(ciphers -> sslContextBuilder.ciphers((Iterable)tlsConfiguration.cipherSuites().allowed(), (CipherSuiteFilter)new DenyCipherSuiteFilter(tlsConfiguration.cipherSuites().denied())));
    }

    private static void configureEnabledProtocols(SslContextBuilder sslContextBuilder, Tls tlsConfiguration) {
        Optional<AllowDeny> protocols = Optional.ofNullable(tlsConfiguration.protocols());
        List<String> defaultProtocols = Arrays.stream(VirtualClusterModel.getDefaultSSLParameters().getProtocols()).toList();
        List<String> supportedProtocols = Arrays.stream(VirtualClusterModel.getSupportedSSLParameters().getProtocols()).toList();
        protocols.ifPresent(allowDeny -> {
            List allowedProtocols = protocols.map(AllowDeny::allowed).orElse(defaultProtocols);
            Set deniedProtocols = protocols.map(AllowDeny::denied).orElse(Set.of());
            allowedProtocols.stream().filter(Predicate.not(supportedProtocols::contains)).forEach(unsupportedProtocol -> LOGGER.warn("Ignoring allowed protocol '{}' as it is not recognized by this platform (supported protocols: {})", unsupportedProtocol, (Object)supportedProtocols));
            deniedProtocols.stream().filter(Predicate.not(supportedProtocols::contains)).forEach(unsupportedProtocol -> LOGGER.warn("Ignoring denied protocol '{}' as it is not recognized by this platform (supported protocols: {})", unsupportedProtocol, (Object)supportedProtocols));
            List<String> protocolsToUse = allowedProtocols.stream().filter(supportedProtocols::contains).filter(Predicate.not(deniedProtocols::contains)).toList();
            if (protocolsToUse.isEmpty()) {
                throw new IllegalConfigurationException("The protocols configuration you have in place has resulted in no protocols being set. Allowed: " + String.valueOf(allowedProtocols) + ", Denied: " + String.valueOf(deniedProtocols));
            }
            sslContextBuilder.protocols(protocolsToUse);
        });
    }

    private static SSLParameters getDefaultSSLParameters() {
        try {
            return SSLContext.getDefault().getDefaultSSLParameters();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SslContextBuildException(e);
        }
    }

    private static SSLParameters getSupportedSSLParameters() {
        try {
            return SSLContext.getDefault().getSupportedSSLParameters();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SslContextBuildException(e);
        }
    }

    public List<NamedFilterDefinition> getFilters() {
        return this.filters;
    }

    public Map<String, EndpointGateway> gateways() {
        return Collections.unmodifiableMap(this.gateways);
    }

    public static class VirtualClusterGatewayModel
    implements EndpointGateway {
        private final VirtualClusterModel virtualCluster;
        private final NodeIdentificationStrategy nodeIdentificationStrategy;
        private final Optional<Tls> tls;
        private final Optional<SslContext> downstreamSslContext;
        private final String name;

        VirtualClusterGatewayModel(VirtualClusterModel virtualCluster, NodeIdentificationStrategy nodeIdentificationStrategy, Optional<Tls> tls, String name) {
            this.virtualCluster = virtualCluster;
            this.nodeIdentificationStrategy = nodeIdentificationStrategy;
            this.tls = tls;
            this.name = name;
            this.validatePortUsage(nodeIdentificationStrategy);
            this.validateTLsSettings(nodeIdentificationStrategy, tls);
            this.downstreamSslContext = this.buildDownstreamSslContext();
        }

        private void validatePortUsage(NodeIdentificationStrategy nodeIdentificationStrategy) {
            Set conflicts = nodeIdentificationStrategy.getExclusivePorts().stream().filter(p -> nodeIdentificationStrategy.getSharedPorts().contains(p)).collect(Collectors.toSet());
            if (!conflicts.isEmpty()) {
                throw new IllegalStateException("The set of exclusive ports described by the Node Identification Strategy must be distinct from those described as shared. Intersection: " + String.valueOf(conflicts));
            }
        }

        private void validateTLsSettings(NodeIdentificationStrategy nodeIdentificationStrategy, Optional<Tls> tls) {
            if (nodeIdentificationStrategy.requiresServerNameIndication() && (tls.isEmpty() || !tls.get().definesKey())) {
                throw new IllegalStateException("Node Identification Strategy requires ServerNameIndication, but virtual cluster gateway '%s' does not configure TLS and provide a certificate for the server".formatted(this.name()));
            }
        }

        @Override
        public VirtualClusterModel virtualCluster() {
            return this.virtualCluster;
        }

        private NodeIdentificationStrategy getNodeIdentificationStrategy() {
            return this.nodeIdentificationStrategy;
        }

        @Override
        public HostPort getClusterBootstrapAddress() {
            return this.getNodeIdentificationStrategy().getClusterBootstrapAddress();
        }

        @Override
        public TargetCluster targetCluster() {
            return this.virtualCluster.targetCluster();
        }

        @Override
        public HostPort getBrokerAddress(int nodeId) throws IllegalArgumentException {
            return this.getNodeIdentificationStrategy().getBrokerAddress(nodeId);
        }

        @Override
        public Optional<String> getBindAddress() {
            return this.getNodeIdentificationStrategy().getBindAddress();
        }

        @Override
        public boolean requiresServerNameIndication() {
            return this.getNodeIdentificationStrategy().requiresServerNameIndication();
        }

        @Override
        public Set<Integer> getExclusivePorts() {
            return this.getNodeIdentificationStrategy().getExclusivePorts();
        }

        @Override
        public Set<Integer> getSharedPorts() {
            return this.getNodeIdentificationStrategy().getSharedPorts();
        }

        @Override
        public Map<Integer, HostPort> discoveryAddressMap() {
            return this.getNodeIdentificationStrategy().discoveryAddressMap();
        }

        @Override
        @Nullable
        public Integer getBrokerIdFromBrokerAddress(HostPort brokerAddress) {
            return this.getNodeIdentificationStrategy().getBrokerIdFromBrokerAddress(brokerAddress);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public HostPort getAdvertisedBrokerAddress(int nodeId) {
            return this.getNodeIdentificationStrategy().getAdvertisedBrokerAddress(nodeId);
        }

        @Override
        public boolean isUseTls() {
            return this.tls.isPresent();
        }

        @Override
        public Optional<SslContext> getDownstreamSslContext() {
            return this.downstreamSslContext;
        }

        public Optional<Tls> getTls() {
            return this.tls;
        }

        private Optional<SslContext> buildDownstreamSslContext() {
            return this.tls.map(tlsConfiguration -> {
                if (tlsConfiguration.key() == null) {
                    throw new IllegalConfigurationException("Virtual cluster '%s', gateway '%s': 'tls' object is missing the mandatory attribute 'key'. See %s for details".formatted(this.virtualCluster.getClusterName(), this.name(), StableKroxyliciousLinkGenerator.INSTANCE.errorLink("clientTls")));
                }
                try {
                    SslContextBuilder sslContextBuilder = Optional.of(tlsConfiguration.key()).map(NettyKeyProvider::new).map(NettyKeyProvider::forServer).orElseThrow();
                    VirtualClusterModel.configureCipherSuites(sslContextBuilder, tlsConfiguration);
                    VirtualClusterModel.configureEnabledProtocols(sslContextBuilder, tlsConfiguration);
                    return VirtualClusterModel.configureTrustProvider(tlsConfiguration).apply(sslContextBuilder).build();
                }
                catch (SSLException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }

        public String toString() {
            return "VirtualClusterGatewayModel[name=" + this.name + ", virtualCluster=" + this.virtualCluster.getClusterName() + ", nodeIdentificationStrategy=" + String.valueOf(this.nodeIdentificationStrategy) + ", tls=" + this.isUseTls() + "]";
        }
    }
}

