/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.license;

import io.confluent.license.License;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class LicenseSelectionStrategy {
    private final AtomicReference<Function<List<License>, License>> selectionFunction;

    public LicenseSelectionStrategy() {
        this.selectionFunction = new AtomicReference<Function<List, License>>(this::selectBestLicenseDefault);
    }

    public LicenseSelectionStrategy(Function<List<License>, License> selectionFunction) {
        this.selectionFunction = new AtomicReference<Function>(Objects.requireNonNullElseGet(selectionFunction, () -> this::selectBestLicenseDefault));
    }

    public License selectLicense(List<License> licenses) {
        return this.selectionFunction.get().apply(licenses);
    }

    private License selectBestLicenseDefault(List<License> licenses) {
        if (licenses == null || licenses.isEmpty()) {
            return null;
        }
        if (licenses.size() == 1) {
            return licenses.get(0);
        }
        return licenses.stream().max(this::compareByExpiration).orElse(null);
    }

    private int compareByExpiration(License l1, License l2) {
        Date exp1 = l1.expirationDate();
        Date exp2 = l2.expirationDate();
        if (exp1 == null && exp2 == null) {
            return 0;
        }
        if (exp1 == null) {
            return -1;
        }
        if (exp2 == null) {
            return 1;
        }
        return exp1.compareTo(exp2);
    }
}

