/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.common;

import io.confluent.csid.config.provider.common.Subscription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.config.ConfigChangeCallback;
import org.immutables.value.Generated;

@Generated(from="Subscription.State", generator="Immutables")
public final class ImmutableState
implements Subscription.State {
    private final Set<ConfigChangeCallback> callbacks;

    private ImmutableState(Set<ConfigChangeCallback> callbacks) {
        this.callbacks = callbacks;
    }

    @Override
    public Set<ConfigChangeCallback> callbacks() {
        return this.callbacks;
    }

    public final ImmutableState withCallbacks(ConfigChangeCallback ... elements) {
        Set<ConfigChangeCallback> newValue = ImmutableState.createUnmodifiableSet(ImmutableState.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableState(newValue);
    }

    public final ImmutableState withCallbacks(Iterable<? extends ConfigChangeCallback> elements) {
        if (this.callbacks == elements) {
            return this;
        }
        Set<ConfigChangeCallback> newValue = ImmutableState.createUnmodifiableSet(ImmutableState.createSafeList(elements, true, false));
        return new ImmutableState(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableState && this.equalTo(0, (ImmutableState)another);
    }

    private boolean equalTo(int synthetic, ImmutableState another) {
        return this.callbacks.equals(another.callbacks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.callbacks.hashCode();
        return h;
    }

    public String toString() {
        return "State{callbacks=" + this.callbacks + "}";
    }

    public static ImmutableState copyOf(Subscription.State instance) {
        if (instance instanceof ImmutableState) {
            return (ImmutableState)instance;
        }
        return ImmutableState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="Subscription.State", generator="Immutables")
    public static final class Builder {
        private List<ConfigChangeCallback> callbacks = new ArrayList<ConfigChangeCallback>();

        private Builder() {
        }

        public final Builder from(Subscription.State instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllCallbacks(instance.callbacks());
            return this;
        }

        public final Builder addCallbacks(ConfigChangeCallback element) {
            this.callbacks.add(Objects.requireNonNull(element, "callbacks element"));
            return this;
        }

        public final Builder addCallbacks(ConfigChangeCallback ... elements) {
            for (ConfigChangeCallback element : elements) {
                this.callbacks.add(Objects.requireNonNull(element, "callbacks element"));
            }
            return this;
        }

        public final Builder callbacks(Iterable<? extends ConfigChangeCallback> elements) {
            this.callbacks.clear();
            return this.addAllCallbacks(elements);
        }

        public final Builder addAllCallbacks(Iterable<? extends ConfigChangeCallback> elements) {
            for (ConfigChangeCallback configChangeCallback : elements) {
                this.callbacks.add(Objects.requireNonNull(configChangeCallback, "callbacks element"));
            }
            return this;
        }

        public ImmutableState build() {
            return new ImmutableState(ImmutableState.createUnmodifiableSet(this.callbacks));
        }
    }
}

