/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.common;

import io.confluent.csid.config.provider.common.ImmutableSecretRequest;
import io.confluent.csid.config.provider.common.SecretRequest;
import java.net.URI;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class SecretRequestParser {
    SecretRequestParser() {
    }

    private static Map<String, String> parseParams(URI uri) {
        Map<String, String> results = null != uri.getQuery() ? Stream.of(uri.getQuery().split("&")).map(s -> {
            String[] parts = s.split("=");
            return new AbstractMap.SimpleImmutableEntry<String, Object>(parts[0], (parts.length == 2 ? parts[1] : null));
        }).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, AbstractMap.SimpleImmutableEntry::getValue)) : new LinkedHashMap<String, String>();
        return results;
    }

    public static SecretRequest parse(String input) {
        URI uri = URI.create(input);
        Map<String, String> params = SecretRequestParser.parseParams(uri);
        return ImmutableSecretRequest.builder().raw(input).version(Optional.ofNullable(params.get("version"))).path(uri.getPath()).build();
    }
}

