/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.client;

import io.confluent.gateway.filter.authswap.client.FailureResponseBuilder;
import io.confluent.gateway.filter.authswap.client.ResponseBuilder;
import io.kroxylicious.proxy.filter.RequestFilterResult;
import lombok.Generated;

public class AuthResult {
    private final AuthStatus status;
    private final String clientId;
    private final RequestFilterResult filterResult;
    private final Throwable error;
    private final short errorCode;
    private final boolean shouldForwardRequest;
    private final ResponseBuilder<?> responseBuilder;
    private final FailureResponseBuilder<?> failureResponseBuilder;

    private AuthResult(AuthStatus status, String clientId, RequestFilterResult filterResult, Throwable error, boolean shouldForwardRequest, ResponseBuilder<?> responseBuilder, short errorCode, FailureResponseBuilder<?> failureResponseBuilder) {
        this.status = status;
        this.clientId = clientId;
        this.filterResult = filterResult;
        this.error = error;
        this.errorCode = errorCode;
        this.shouldForwardRequest = shouldForwardRequest;
        this.responseBuilder = responseBuilder;
        this.failureResponseBuilder = failureResponseBuilder;
    }

    private AuthResult(AuthStatus status, String clientId, RequestFilterResult filterResult, Throwable error, boolean shouldForwardRequest, short errorCode, FailureResponseBuilder<?> failureResponseBuilder) {
        this(status, clientId, filterResult, error, shouldForwardRequest, null, errorCode, failureResponseBuilder);
    }

    public static AuthResult success(String clientId) {
        return new AuthResult(AuthStatus.SUCCESS, clientId, null, null, true, 0, null);
    }

    public static AuthResult successWithResponseBuilder(String clientId, ResponseBuilder<?> responseBuilder, FailureResponseBuilder<?> failureResponseBuilder) {
        return new AuthResult(AuthStatus.SUCCESS, clientId, null, null, false, responseBuilder, 0, failureResponseBuilder);
    }

    public static AuthResult continueWithResponse(RequestFilterResult filterResult) {
        return new AuthResult(AuthStatus.CONTINUE, null, filterResult, null, false, 0, null);
    }

    public static AuthResult failure(RequestFilterResult filterResult) {
        return new AuthResult(AuthStatus.FAILURE, null, filterResult, null, false, 0, null);
    }

    public static AuthResult failure(Throwable error, short errorCode) {
        return new AuthResult(AuthStatus.FAILURE, null, null, error, false, errorCode, null);
    }

    public boolean isSuccess() {
        return this.status == AuthStatus.SUCCESS;
    }

    public boolean isContinue() {
        return this.status == AuthStatus.CONTINUE;
    }

    public boolean isFailure() {
        return this.status == AuthStatus.FAILURE;
    }

    public boolean shouldForwardRequest() {
        return this.shouldForwardRequest;
    }

    @Generated
    public AuthStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public RequestFilterResult getFilterResult() {
        return this.filterResult;
    }

    @Generated
    public Throwable getError() {
        return this.error;
    }

    @Generated
    public short getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public ResponseBuilder<?> getResponseBuilder() {
        return this.responseBuilder;
    }

    @Generated
    public FailureResponseBuilder<?> getFailureResponseBuilder() {
        return this.failureResponseBuilder;
    }

    public static enum AuthStatus {
        SUCCESS,
        CONTINUE,
        FAILURE;

    }
}

