/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.cluster;

import io.confluent.gateway.filter.authswap.Session;
import io.confluent.gateway.filter.authswap.cluster.ClusterAuthProcessor;
import io.confluent.gateway.filter.authswap.cluster.NoneClusterAuthProcessor;
import io.confluent.gateway.filter.authswap.cluster.SaslClusterAuthProcessor;
import io.confluent.gateway.filter.authswap.config.AuthSwapFilterConfig;
import io.confluent.gateway.filter.authswap.config.ClusterAuth;
import io.confluent.gateway.filter.authswap.metrics.AuthMetricsRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAuthProcessorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterAuthProcessorFactory.class);

    public static ClusterAuthProcessor createClusterAuthProcessor(AuthSwapFilterConfig authSwapConfig, Session session, AuthMetricsRecorder recorder) {
        ClusterAuth clusterAuth = authSwapConfig.config().clusterAuth();
        if (clusterAuth.sasl() != null) {
            LOGGER.info("Creating SaslClusterAuthProcessor for SASL mechanism: {}", (Object)clusterAuth.sasl().mechanism());
            return new SaslClusterAuthProcessor(authSwapConfig, session, recorder);
        }
        if (clusterAuth.none() != null) {
            LOGGER.info("Creating NoAuthClusterAuthProcessor for NONE cluster auth");
            return new NoneClusterAuthProcessor(session, recorder);
        }
        throw new IllegalArgumentException("Invalid cluster auth config: no auth mechanism specified");
    }
}

