/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.cluster;

import io.confluent.gateway.filter.authswap.Session;
import io.confluent.gateway.filter.authswap.cluster.ClusterAuthProcessor;
import io.confluent.gateway.filter.authswap.metrics.AuthMetricsRecorder;
import io.kroxylicious.proxy.filter.FilterContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.apache.kafka.common.protocol.ApiKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoneClusterAuthProcessor
implements ClusterAuthProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoneClusterAuthProcessor.class);
    private final Session session;
    private final AuthMetricsRecorder recorder;

    @Override
    public CompletionStage<ClusterAuthProcessor.AuthData> authenticate(FilterContext context, String incomingClientId) {
        LOGGER.debug("Establishing no-auth connection to cluster for channel: {}, ignoring client ID: {}", (Object)context.channelDescriptor(), (Object)incomingClientId);
        this.session.updateGatewayToClusterSession(0L);
        this.recorder.incrementClusterAuthSuccess(context.getVirtualClusterName());
        LOGGER.info("Successfully established no-auth connection to cluster for channel: {}", (Object)context.channelDescriptor());
        return CompletableFuture.completedStage(new ClusterAuthProcessor.AuthData(new byte[0]));
    }

    @Override
    public CompletionStage<ClusterAuthProcessor.AuthData> handleClusterAuthenticateResponse(Object response, FilterContext context) {
        LOGGER.error("Unexpected handleClusterAuthenticateResponse called for no-auth processor on channel: {}", (Object)context.channelDescriptor());
        this.recorder.incrementClusterAuthFailure(context.getVirtualClusterName());
        return CompletableFuture.failedStage(new IllegalStateException("No-auth processor should not receive authentication responses"));
    }

    @Override
    public boolean shouldInterceptForGatewayAuth(ApiKeys apiKey, short apiVersion) {
        return this.session.isClusterConnectionEstablished() == false;
    }

    @Override
    public boolean shouldInterceptForGatewayReauth(ApiKeys apiKey, short apiVersion) {
        return false;
    }

    @Generated
    public NoneClusterAuthProcessor(Session session, AuthMetricsRecorder recorder) {
        this.session = session;
        this.recorder = recorder;
    }
}

