/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.filter.authswap.utils.ConfigUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public record OauthClientConfig(@JsonProperty String scopeClaimName, @JsonProperty String subClaimName, @JsonProperty(required=true) URI tokenEndpointUri) {
    public static OauthClientConfig withDefaults(OauthClientConfig config) {
        return new OauthClientConfig(ConfigUtil.defaultIfNullOrEmpty(config.scopeClaimName(), "scope"), ConfigUtil.defaultIfNullOrEmpty(config.subClaimName(), "sub"), config.tokenEndpointUri());
    }

    public boolean isValid() {
        return this.tokenEndpointUri != null;
    }

    public Map<String, Object> toLoginSaslConfigMap() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("sasl.oauthbearer.token.endpoint.url", this.tokenEndpointUri.toString());
        configMap.put("sasl.oauthbearer.scope.claim.name", this.scopeClaimName);
        configMap.put("sasl.oauthbearer.sub.claim.name", this.subClaimName);
        return configMap;
    }
}

