/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.filter.authswap.config.JaasConfig;
import io.confluent.gateway.filter.authswap.config.OauthServerConfig;
import io.confluent.gateway.filter.authswap.config.SupportedSaslMechanism;
import io.kroxylicious.proxy.plugin.PluginConfigurationException;
import org.apache.commons.lang3.StringUtils;

public record SaslServer(@JsonProperty(required=true) String callbackHandlerClass, @JsonProperty(required=true) String mechanism, @JsonProperty OauthServerConfig oauth, @JsonProperty(required=true) JaasConfig jaasConfig) {
    public SaslServer {
        if (!SupportedSaslMechanism.isValidMechanism(mechanism)) {
            throw new PluginConfigurationException("SASL mechanism must be one of: " + String.join((CharSequence)", ", SupportedSaslMechanism.all()));
        }
        if (StringUtils.equals((CharSequence)SupportedSaslMechanism.OAUTHBEARER.getMechanism(), (CharSequence)mechanism)) {
            if (oauth == null) {
                throw new PluginConfigurationException("OauthConfig must be provided for OAUTHBEARER mechanism");
            }
            if (!oauth.isValid()) {
                throw new PluginConfigurationException("JWKS Endpoint URL is required for ClientAuth when using OAUTHBEARER mechanism");
            }
        }
    }

    public static SaslServer withDefaults(SaslServer config) {
        if (config == null) {
            return null;
        }
        return new SaslServer(config.callbackHandlerClass(), config.mechanism(), config.oauth == null ? null : OauthServerConfig.withDefaults(config.oauth()), config.jaasConfig == null ? null : JaasConfig.withDefaults(config.jaasConfig()));
    }
}

