/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.response;

import io.confluent.gateway.filter.authswap.response.ErrorResponseBuilder;
import io.confluent.gateway.filter.authswap.response.SimpleApiErrorCreators;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.message.AlterClientQuotasRequestData;
import org.apache.kafka.common.message.AlterClientQuotasResponseData;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterReplicaLogDirsRequestData;
import org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DeleteGroupsRequestData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.message.DeleteShareGroupStateRequestData;
import org.apache.kafka.common.message.DeleteShareGroupStateResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.message.DescribeProducersRequestData;
import org.apache.kafka.common.message.DescribeProducersResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsRequestData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeTransactionsRequestData;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.InitializeShareGroupStateRequestData;
import org.apache.kafka.common.message.InitializeShareGroupStateResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.message.ReadShareGroupStateRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateResponseData;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryResponseData;
import org.apache.kafka.common.message.ShareGroupDescribeRequestData;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.message.WriteShareGroupStateRequestData;
import org.apache.kafka.common.message.WriteShareGroupStateResponseData;
import org.apache.kafka.common.message.WriteTxnMarkersRequestData;
import org.apache.kafka.common.message.WriteTxnMarkersResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponseBuilderRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorResponseBuilderRegistry.class);
    private static final Map<ApiKeys, ErrorResponseBuilder> RESPONSE_CREATORS = new HashMap<ApiKeys, ErrorResponseBuilder>();
    private static final String SET_MESSAGE_NOT_FOUND_ERROR = "{} response does not support setting error messagesbut received: {}";

    public static ErrorResponseBuilder getResponseBuilder(ApiKeys apiKey) {
        return RESPONSE_CREATORS.getOrDefault(apiKey, ErrorResponseBuilderRegistry.createDefaultErrorCreator());
    }

    public static Optional<ApiMessage> createErrorResponse(ApiKeys apiKey, ApiMessage request, short errorCode, String errorMessage) {
        return ErrorResponseBuilderRegistry.getResponseBuilder(apiKey).build(apiKey, request, errorCode, errorMessage);
    }

    public static Optional<ApiMessage> createErrorResponse(ApiKeys apiKey, ApiMessage request, short errorCode) {
        return ErrorResponseBuilderRegistry.createErrorResponse(apiKey, request, errorCode, null);
    }

    public static Optional<ApiMessage> createErrorResponse(short apiKeyId, ApiMessage request, short errorCode, String errorMessage) {
        ApiKeys apiKey = ApiKeys.forId((int)apiKeyId);
        return ErrorResponseBuilderRegistry.createErrorResponse(apiKey, request, errorCode, errorMessage);
    }

    public static Optional<ApiMessage> createErrorResponse(short apiKeyId, ApiMessage request, short errorCode) {
        return ErrorResponseBuilderRegistry.createErrorResponse(apiKeyId, request, errorCode, null);
    }

    private static void registerSimpleApis() {
        try {
            Map<ApiKeys, ErrorResponseBuilder> simpleApiCreators = SimpleApiErrorCreators.getAllErrorResponses();
            HashMap<ApiKeys, ErrorResponseBuilder> newCreators = new HashMap<ApiKeys, ErrorResponseBuilder>();
            for (Map.Entry<ApiKeys, ErrorResponseBuilder> entry : simpleApiCreators.entrySet()) {
                if (!RESPONSE_CREATORS.containsKey(entry.getKey())) {
                    newCreators.put(entry.getKey(), entry.getValue());
                    continue;
                }
                LOGGER.debug("Skipping {} - already registered as complex API", (Object)entry.getKey().name());
            }
            RESPONSE_CREATORS.putAll(newCreators);
            LOGGER.info("Registered {} simple APIs using generated SimpleApiErrorCreators", (Object)newCreators.size());
        }
        catch (Exception e) {
            LOGGER.error("Failed to register simple APIs from generated class", (Throwable)e);
        }
    }

    private static void initializeErrorResponseBuilders() {
        RESPONSE_CREATORS.put(ApiKeys.PRODUCE, (apiKey, request, errorCode, errorMessage) -> {
            ProduceResponseData response = new ProduceResponseData();
            ProduceRequestData produceRequest = (ProduceRequestData)request;
            produceRequest.topicData().forEach(topicData -> {
                ProduceResponseData.TopicProduceResponse topicResponse = new ProduceResponseData.TopicProduceResponse().setName(topicData.name());
                topicData.partitionData().forEach(partitionData -> {
                    ProduceResponseData.PartitionProduceResponse partitionResponse = new ProduceResponseData.PartitionProduceResponse().setIndex(partitionData.index()).setErrorCode(errorCode).setErrorMessage(errorMessage);
                    topicResponse.partitionResponses().add(partitionResponse);
                });
                response.responses().add((ImplicitLinkedHashCollection.Element)topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.FETCH, (apiKey, request, errorCode, errorMessage) -> {
            FetchResponseData response = new FetchResponseData();
            FetchRequestData fetchRequest = (FetchRequestData)request;
            fetchRequest.topics().forEach(topicData -> {
                FetchResponseData.FetchableTopicResponse topicResponse = new FetchResponseData.FetchableTopicResponse().setTopic(topicData.topic());
                topicData.partitions().forEach(partitionData -> {
                    FetchResponseData.PartitionData partitionResponse = new FetchResponseData.PartitionData().setPartitionIndex(partitionData.partition()).setErrorCode(errorCode);
                    topicResponse.partitions().add(partitionResponse);
                });
                response.responses().add(topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.OFFSET_COMMIT, (apiKey, request, errorCode, errorMessage) -> {
            OffsetCommitResponseData response = new OffsetCommitResponseData();
            OffsetCommitRequestData offsetCommitRequest = (OffsetCommitRequestData)request;
            offsetCommitRequest.topics().forEach(topicData -> {
                OffsetCommitResponseData.OffsetCommitResponseTopic topicResponse = new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(topicData.name());
                topicData.partitions().forEach(partitionData -> {
                    OffsetCommitResponseData.OffsetCommitResponsePartition partitionResponse = new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(partitionData.partitionIndex()).setErrorCode(errorCode);
                    topicResponse.partitions().add(partitionResponse);
                });
                response.topics().add(topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.CREATE_TOPICS, (apiKey, request, errorCode, errorMessage) -> {
            CreateTopicsResponseData response = new CreateTopicsResponseData();
            CreateTopicsRequestData createTopicsRequest = (CreateTopicsRequestData)request;
            createTopicsRequest.topics().forEach(topicData -> {
                CreateTopicsResponseData.CreatableTopicResult topicResult = new CreateTopicsResponseData.CreatableTopicResult().setName(topicData.name()).setErrorCode(errorCode);
                if (errorMessage != null) {
                    topicResult.setErrorMessage(errorMessage);
                }
                response.topics().add((ImplicitLinkedHashCollection.Element)topicResult);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.DELETE_TOPICS, (apiKey, request, errorCode, errorMessage) -> {
            DeleteTopicsResponseData response = new DeleteTopicsResponseData();
            DeleteTopicsRequestData deleteTopicsRequest = (DeleteTopicsRequestData)request;
            deleteTopicsRequest.topicNames().forEach(topicName -> {
                DeleteTopicsResponseData.DeletableTopicResult topicResult = new DeleteTopicsResponseData.DeletableTopicResult().setName(topicName).setErrorCode(errorCode);
                if (errorMessage != null) {
                    topicResult.setErrorMessage(errorMessage);
                }
                response.responses().add((ImplicitLinkedHashCollection.Element)topicResult);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.LIST_OFFSETS, (apiKey, request, errorCode, errorMessage) -> {
            ListOffsetsResponseData response = new ListOffsetsResponseData();
            ListOffsetsRequestData listRequest = (ListOffsetsRequestData)request;
            listRequest.topics().forEach(topicData -> {
                ListOffsetsResponseData.ListOffsetsTopicResponse topicResponse = new ListOffsetsResponseData.ListOffsetsTopicResponse().setName(topicData.name());
                topicData.partitions().forEach(partitionData -> {
                    ListOffsetsResponseData.ListOffsetsPartitionResponse partitionResponse = new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(partitionData.partitionIndex()).setErrorCode(errorCode);
                    topicResponse.partitions().add(partitionResponse);
                });
                response.topics().add(topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.OFFSET_FETCH, (apiKey, request, errorCode, errorMessage) -> {
            OffsetFetchResponseData response = new OffsetFetchResponseData();
            OffsetFetchRequestData offsetRequest = (OffsetFetchRequestData)request;
            offsetRequest.topics().forEach(topicData -> {
                OffsetFetchResponseData.OffsetFetchResponseTopic topicResponse = new OffsetFetchResponseData.OffsetFetchResponseTopic().setName(topicData.name());
                topicData.partitionIndexes().forEach(partitionIndex -> {
                    OffsetFetchResponseData.OffsetFetchResponsePartition partitionResponse = new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(partitionIndex.intValue()).setErrorCode(errorCode);
                    topicResponse.partitions().add(partitionResponse);
                });
                response.topics().add(topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.DESCRIBE_GROUPS, (apiKey, request, errorCode, errorMessage) -> {
            DescribeGroupsResponseData response = new DescribeGroupsResponseData();
            DescribeGroupsRequestData describeRequest = (DescribeGroupsRequestData)request;
            describeRequest.groups().forEach(groupId -> {
                DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId).setErrorCode(errorCode);
                if (errorMessage != null) {
                    group.setErrorMessage(errorMessage);
                }
                response.groups().add(group);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.DELETE_RECORDS, (apiKey, request, errorCode, errorMessage) -> {
            DeleteRecordsResponseData response = new DeleteRecordsResponseData();
            DeleteRecordsRequestData deleteRequest = (DeleteRecordsRequestData)request;
            deleteRequest.topics().forEach(topicData -> {
                DeleteRecordsResponseData.DeleteRecordsTopicResult topicResponse = new DeleteRecordsResponseData.DeleteRecordsTopicResult().setName(topicData.name());
                topicData.partitions().forEach(partitionData -> {
                    DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResponse = new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(partitionData.partitionIndex()).setErrorCode(errorCode);
                    topicResponse.partitions().add((ImplicitLinkedHashCollection.Element)partitionResponse);
                });
                response.topics().add((ImplicitLinkedHashCollection.Element)topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.OFFSET_FOR_LEADER_EPOCH, (apiKey, request, errorCode, errorMessage) -> {
            OffsetForLeaderEpochResponseData response = new OffsetForLeaderEpochResponseData();
            OffsetForLeaderEpochRequestData epochRequest = (OffsetForLeaderEpochRequestData)request;
            epochRequest.topics().forEach(topicData -> {
                OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult topicResponse = new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic(topicData.topic());
                topicData.partitions().forEach(partitionData -> {
                    OffsetForLeaderEpochResponseData.EpochEndOffset partitionResponse = new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionData.partition()).setErrorCode(errorCode);
                    topicResponse.partitions().add(partitionResponse);
                });
                response.topics().add((ImplicitLinkedHashCollection.Element)topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.WRITE_TXN_MARKERS, (apiKey, request, errorCode, errorMessage) -> {
            WriteTxnMarkersResponseData response = new WriteTxnMarkersResponseData();
            WriteTxnMarkersRequestData markersRequest = (WriteTxnMarkersRequestData)request;
            markersRequest.markers().forEach(markerData -> {
                WriteTxnMarkersResponseData.WritableTxnMarkerResult markerResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerResult().setProducerId(markerData.producerId());
                markerData.topics().forEach(topicData -> {
                    WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult topicResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult().setName(topicData.name());
                    topicData.partitionIndexes().forEach(partitionIndex -> {
                        WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult partitionResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult().setPartitionIndex(partitionIndex.intValue()).setErrorCode(errorCode);
                        topicResponse.partitions().add(partitionResponse);
                    });
                    markerResponse.topics().add(topicResponse);
                });
                response.markers().add(markerResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.TXN_OFFSET_COMMIT, (apiKey, request, errorCode, errorMessage) -> {
            TxnOffsetCommitResponseData response = new TxnOffsetCommitResponseData();
            TxnOffsetCommitRequestData txnOffsetRequest = (TxnOffsetCommitRequestData)request;
            txnOffsetRequest.topics().forEach(topicData -> {
                TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic topicResponse = new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(topicData.name());
                topicData.partitions().forEach(partitionData -> {
                    TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition partitionResponse = new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(partitionData.partitionIndex()).setErrorCode(errorCode);
                    topicResponse.partitions().add(partitionResponse);
                });
                response.topics().add(topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.CREATE_ACLS, (apiKey, request, errorCode, errorMessage) -> {
            CreateAclsResponseData response = new CreateAclsResponseData();
            CreateAclsRequestData createAclsRequest = (CreateAclsRequestData)request;
            createAclsRequest.creations().forEach(creation -> {
                CreateAclsResponseData.AclCreationResult result = new CreateAclsResponseData.AclCreationResult().setErrorCode(errorCode);
                if (errorMessage != null) {
                    result.setErrorMessage(errorMessage);
                }
                response.results().add(result);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.DELETE_ACLS, (apiKey, request, errorCode, errorMessage) -> {
            DeleteAclsResponseData response = new DeleteAclsResponseData();
            DeleteAclsRequestData deleteAclsRequest = (DeleteAclsRequestData)request;
            deleteAclsRequest.filters().forEach(filter -> {
                DeleteAclsResponseData.DeleteAclsFilterResult result = new DeleteAclsResponseData.DeleteAclsFilterResult().setErrorCode(errorCode);
                if (errorMessage != null) {
                    result.setErrorMessage(errorMessage);
                }
                response.filterResults().add(result);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.DESCRIBE_CONFIGS, (apiKey, request, errorCode, errorMessage) -> {
            DescribeConfigsResponseData response = new DescribeConfigsResponseData();
            DescribeConfigsRequestData describeConfigsRequest = (DescribeConfigsRequestData)request;
            describeConfigsRequest.resources().forEach(resource -> {
                DescribeConfigsResponseData.DescribeConfigsResult result = new DescribeConfigsResponseData.DescribeConfigsResult().setResourceType(resource.resourceType()).setResourceName(resource.resourceName()).setErrorCode(errorCode);
                if (errorMessage != null) {
                    result.setErrorMessage(errorMessage);
                }
                response.results().add(result);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.ALTER_CONFIGS, (apiKey, request, errorCode, errorMessage) -> {
            AlterConfigsResponseData response = new AlterConfigsResponseData();
            AlterConfigsRequestData alterConfigsRequest = (AlterConfigsRequestData)request;
            alterConfigsRequest.resources().forEach(resource -> {
                AlterConfigsResponseData.AlterConfigsResourceResponse result = new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(resource.resourceType()).setResourceName(resource.resourceName()).setErrorCode(errorCode);
                if (errorMessage != null) {
                    result.setErrorMessage(errorMessage);
                }
                response.responses().add(result);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.ALTER_REPLICA_LOG_DIRS, (apiKey, request, errorCode, errorMessage) -> {
            AlterReplicaLogDirsResponseData response = new AlterReplicaLogDirsResponseData();
            AlterReplicaLogDirsRequestData alterReplicaRequest = (AlterReplicaLogDirsRequestData)request;
            alterReplicaRequest.dirs().forEach(dir -> dir.topics().forEach(topicData -> {
                AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult topicResponse = new AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult().setTopicName(topicData.name());
                topicData.partitions().forEach(partitionIndex -> {
                    AlterReplicaLogDirsResponseData.AlterReplicaLogDirPartitionResult partitionResponse = new AlterReplicaLogDirsResponseData.AlterReplicaLogDirPartitionResult().setPartitionIndex(partitionIndex.intValue()).setErrorCode(errorCode);
                    topicResponse.partitions().add(partitionResponse);
                });
                response.results().add(topicResponse);
            }));
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.DESCRIBE_LOG_DIRS, (apiKey, request, errorCode, errorMessage) -> {
            DescribeLogDirsResponseData response = new DescribeLogDirsResponseData();
            DescribeLogDirsResponseData.DescribeLogDirsResult result = new DescribeLogDirsResponseData.DescribeLogDirsResult().setErrorCode(errorCode).setLogDir("unknown");
            if (errorMessage != null) {
                LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.DESCRIBE_LOG_DIRS, (Object)errorMessage);
            }
            response.results().add(result);
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.CREATE_PARTITIONS, (apiKey, request, errorCode, errorMessage) -> {
            CreatePartitionsResponseData response = new CreatePartitionsResponseData();
            CreatePartitionsRequestData createPartitionsRequest = (CreatePartitionsRequestData)request;
            createPartitionsRequest.topics().forEach(topicData -> {
                CreatePartitionsResponseData.CreatePartitionsTopicResult topicResponse = new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topicData.name()).setErrorCode(errorCode);
                if (errorMessage != null) {
                    topicResponse.setErrorMessage(errorMessage);
                }
                response.results().add(topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.DELETE_GROUPS, (apiKey, request, errorCode, errorMessage) -> {
            DeleteGroupsResponseData response = new DeleteGroupsResponseData();
            DeleteGroupsRequestData deleteGroupsRequest = (DeleteGroupsRequestData)request;
            deleteGroupsRequest.groupsNames().forEach(groupId -> {
                DeleteGroupsResponseData.DeletableGroupResult result = new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(groupId).setErrorCode(errorCode);
                response.results().add((ImplicitLinkedHashCollection.Element)result);
            });
            if (errorMessage != null) {
                LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.DELETE_GROUPS, (Object)errorMessage);
            }
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.ELECT_LEADERS, (apiKey, request, errorCode, errorMessage) -> {
            ElectLeadersResponseData response = new ElectLeadersResponseData();
            ElectLeadersRequestData electLeadersRequest = (ElectLeadersRequestData)request;
            electLeadersRequest.topicPartitions().forEach(topicData -> {
                ElectLeadersResponseData.ReplicaElectionResult topicResponse = new ElectLeadersResponseData.ReplicaElectionResult().setTopic(topicData.topic());
                topicData.partitions().forEach(partitionIndex -> {
                    ElectLeadersResponseData.PartitionResult partitionResponse = new ElectLeadersResponseData.PartitionResult().setPartitionId(partitionIndex.intValue()).setErrorCode(errorCode);
                    if (errorMessage != null) {
                        partitionResponse.setErrorMessage(errorMessage);
                    }
                    topicResponse.partitionResult().add(partitionResponse);
                });
                response.replicaElectionResults().add(topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.INCREMENTAL_ALTER_CONFIGS, (apiKey, request, errorCode, errorMessage) -> {
            IncrementalAlterConfigsResponseData response = new IncrementalAlterConfigsResponseData();
            IncrementalAlterConfigsRequestData incrementalAlterRequest = (IncrementalAlterConfigsRequestData)request;
            incrementalAlterRequest.resources().forEach(resource -> {
                IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse result = new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(resource.resourceType()).setResourceName(resource.resourceName()).setErrorCode(errorCode);
                if (errorMessage != null) {
                    result.setErrorMessage(errorMessage);
                }
                response.responses().add(result);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.ALTER_PARTITION_REASSIGNMENTS, (apiKey, request, errorCode, errorMessage) -> {
            AlterPartitionReassignmentsResponseData response = new AlterPartitionReassignmentsResponseData();
            AlterPartitionReassignmentsRequestData alterPartitionRequest = (AlterPartitionReassignmentsRequestData)request;
            alterPartitionRequest.topics().forEach(topicData -> {
                AlterPartitionReassignmentsResponseData.ReassignableTopicResponse topicResponse = new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName(topicData.name());
                topicData.partitions().forEach(partitionData -> {
                    AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse partitionResponse = new AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse().setPartitionIndex(partitionData.partitionIndex()).setErrorCode(errorCode);
                    if (errorMessage != null) {
                        partitionResponse.setErrorMessage(errorMessage);
                    }
                    topicResponse.partitions().add(partitionResponse);
                });
                response.responses().add(topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.OFFSET_DELETE, (apiKey, request, errorCode, errorMessage) -> {
            OffsetDeleteResponseData response = new OffsetDeleteResponseData();
            OffsetDeleteRequestData offsetDeleteRequest = (OffsetDeleteRequestData)request;
            offsetDeleteRequest.topics().forEach(topicData -> {
                OffsetDeleteResponseData.OffsetDeleteResponseTopic topicResponse = new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topicData.name());
                topicData.partitions().forEach(partitionData -> {
                    OffsetDeleteResponseData.OffsetDeleteResponsePartition partitionResponse = new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(partitionData.partitionIndex()).setErrorCode(errorCode);
                    topicResponse.partitions().add((ImplicitLinkedHashCollection.Element)partitionResponse);
                });
                response.topics().add((ImplicitLinkedHashCollection.Element)topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.ALTER_CLIENT_QUOTAS, (apiKey, request, errorCode, errorMessage) -> {
            AlterClientQuotasResponseData response = new AlterClientQuotasResponseData();
            AlterClientQuotasRequestData alterQuotasRequest = (AlterClientQuotasRequestData)request;
            alterQuotasRequest.entries().forEach(entry -> {
                AlterClientQuotasResponseData.EntryData entryData = new AlterClientQuotasResponseData.EntryData().setErrorCode(errorCode);
                if (errorMessage != null) {
                    entryData.setErrorMessage(errorMessage);
                }
                response.entries().add(entryData);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.ALTER_USER_SCRAM_CREDENTIALS, (apiKey, request, errorCode, errorMessage) -> {
            AlterUserScramCredentialsResponseData response = new AlterUserScramCredentialsResponseData();
            AlterUserScramCredentialsRequestData alterScramRequest = (AlterUserScramCredentialsRequestData)request;
            alterScramRequest.deletions().forEach(deletion -> {
                AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult result = new AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult().setUser(deletion.name()).setErrorCode(errorCode);
                if (errorMessage != null) {
                    result.setErrorMessage(errorMessage);
                }
                response.results().add(result);
            });
            alterScramRequest.upsertions().forEach(upsert -> {
                AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult result = new AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult().setUser(upsert.name()).setErrorCode(errorCode);
                if (errorMessage != null) {
                    result.setErrorMessage(errorMessage);
                }
                response.results().add(result);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.UPDATE_FEATURES, (apiKey, request, errorCode, errorMessage) -> {
            UpdateFeaturesResponseData response = new UpdateFeaturesResponseData();
            UpdateFeaturesRequestData updateFeaturesRequest = (UpdateFeaturesRequestData)request;
            updateFeaturesRequest.featureUpdates().forEach(featureUpdate -> {
                UpdateFeaturesResponseData.UpdatableFeatureResult result = new UpdateFeaturesResponseData.UpdatableFeatureResult().setFeature(featureUpdate.feature()).setErrorCode(errorCode);
                if (errorMessage != null) {
                    result.setErrorMessage(errorMessage);
                }
                response.results().add((ImplicitLinkedHashCollection.Element)result);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.DESCRIBE_PRODUCERS, (apiKey, request, errorCode, errorMessage) -> {
            DescribeProducersResponseData response = new DescribeProducersResponseData();
            DescribeProducersRequestData describeProducersRequest = (DescribeProducersRequestData)request;
            describeProducersRequest.topics().forEach(topicData -> {
                DescribeProducersResponseData.TopicResponse topicResponse = new DescribeProducersResponseData.TopicResponse().setName(topicData.name());
                topicData.partitionIndexes().forEach(partitionIndex -> {
                    DescribeProducersResponseData.PartitionResponse partitionResponse = new DescribeProducersResponseData.PartitionResponse().setPartitionIndex(partitionIndex.intValue()).setErrorCode(errorCode);
                    if (errorMessage != null) {
                        partitionResponse.setErrorMessage(errorMessage);
                    }
                    topicResponse.partitions().add(partitionResponse);
                });
                response.topics().add(topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.DESCRIBE_TRANSACTIONS, (apiKey, request, errorCode, errorMessage) -> {
            DescribeTransactionsResponseData response = new DescribeTransactionsResponseData();
            DescribeTransactionsRequestData describeTransactionsRequest = (DescribeTransactionsRequestData)request;
            describeTransactionsRequest.transactionalIds().forEach(transactionalId -> {
                DescribeTransactionsResponseData.TransactionState state = new DescribeTransactionsResponseData.TransactionState().setTransactionalId(transactionalId).setErrorCode(errorCode);
                response.transactionStates().add(state);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.CONSUMER_GROUP_DESCRIBE, (apiKey, request, errorCode, errorMessage) -> {
            ConsumerGroupDescribeResponseData response = new ConsumerGroupDescribeResponseData();
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.DESCRIBE_TOPIC_PARTITIONS, (apiKey, request, errorCode, errorMessage) -> {
            DescribeTopicPartitionsResponseData response = new DescribeTopicPartitionsResponseData();
            DescribeTopicPartitionsRequestData describeTopicPartitionsRequest = (DescribeTopicPartitionsRequestData)request;
            describeTopicPartitionsRequest.topics().forEach(topicData -> {
                DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic topicResponse = new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setName(topicData.name()).setErrorCode(errorCode);
                response.topics().add((ImplicitLinkedHashCollection.Element)topicResponse);
            });
            if (errorMessage != null) {
                LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.DESCRIBE_TOPIC_PARTITIONS, (Object)errorMessage);
            }
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.SHARE_GROUP_DESCRIBE, (apiKey, request, errorCode, errorMessage) -> {
            ShareGroupDescribeResponseData response = new ShareGroupDescribeResponseData();
            ShareGroupDescribeRequestData describeRequest = (ShareGroupDescribeRequestData)request;
            describeRequest.groupIds().forEach(groupId -> {
                ShareGroupDescribeResponseData.DescribedGroup describedGroupResponse = new ShareGroupDescribeResponseData.DescribedGroup().setGroupId(groupId).setErrorCode(errorCode).setErrorMessage(errorMessage);
                response.groups().add(describedGroupResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.INITIALIZE_SHARE_GROUP_STATE, (apiKey, request, errorCode, errorMessage) -> {
            InitializeShareGroupStateResponseData response = new InitializeShareGroupStateResponseData();
            InitializeShareGroupStateRequestData initializeShareGroupStateRequestData = (InitializeShareGroupStateRequestData)request;
            initializeShareGroupStateRequestData.topics().forEach(topicData -> {
                InitializeShareGroupStateResponseData.InitializeStateResult topicResponse = new InitializeShareGroupStateResponseData.InitializeStateResult().setTopicId(topicData.topicId()).setPartitions(topicData.partitions().stream().map(partitionData -> new InitializeShareGroupStateResponseData.PartitionResult().setPartition(partitionData.partition()).setErrorCode(errorCode).setErrorMessage(errorMessage)).toList());
                response.results().add(topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.READ_SHARE_GROUP_STATE, (apiKey, request, errorCode, errorMessage) -> {
            ReadShareGroupStateResponseData response = new ReadShareGroupStateResponseData();
            ReadShareGroupStateRequestData readShareGroupStateRequestData = (ReadShareGroupStateRequestData)request;
            readShareGroupStateRequestData.topics().forEach(topicData -> {
                ReadShareGroupStateResponseData.ReadStateResult topicResponse = new ReadShareGroupStateResponseData.ReadStateResult().setTopicId(topicData.topicId()).setPartitions(topicData.partitions().stream().map(partitionData -> new ReadShareGroupStateResponseData.PartitionResult().setPartition(partitionData.partition()).setErrorCode(errorCode).setErrorMessage(errorMessage)).toList());
                response.results().add(topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.WRITE_SHARE_GROUP_STATE, (apiKey, request, errorCode, errorMessage) -> {
            WriteShareGroupStateResponseData response = new WriteShareGroupStateResponseData();
            WriteShareGroupStateRequestData writeShareGroupStateRequestData = (WriteShareGroupStateRequestData)request;
            writeShareGroupStateRequestData.topics().forEach(topicData -> {
                WriteShareGroupStateResponseData.WriteStateResult topicResponse = new WriteShareGroupStateResponseData.WriteStateResult().setTopicId(topicData.topicId()).setPartitions(topicData.partitions().stream().map(partitionData -> new WriteShareGroupStateResponseData.PartitionResult().setPartition(partitionData.partition()).setErrorCode(errorCode).setErrorMessage(errorMessage)).toList());
                response.results().add(topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.DELETE_SHARE_GROUP_STATE, (apiKey, request, errorCode, errorMessage) -> {
            DeleteShareGroupStateResponseData response = new DeleteShareGroupStateResponseData();
            DeleteShareGroupStateRequestData deleteShareGroupStateRequestData = (DeleteShareGroupStateRequestData)request;
            deleteShareGroupStateRequestData.topics().forEach(topicData -> {
                DeleteShareGroupStateResponseData.DeleteStateResult topicResponse = new DeleteShareGroupStateResponseData.DeleteStateResult().setTopicId(topicData.topicId()).setPartitions(topicData.partitions().stream().map(partitionData -> new DeleteShareGroupStateResponseData.PartitionResult().setPartition(partitionData.partition()).setErrorCode(errorCode).setErrorMessage(errorMessage)).toList());
                response.results().add(topicResponse);
            });
            return Optional.of(response);
        });
        RESPONSE_CREATORS.put(ApiKeys.READ_SHARE_GROUP_STATE_SUMMARY, (apiKey, request, errorCode, errorMessage) -> {
            ReadShareGroupStateSummaryResponseData response = new ReadShareGroupStateSummaryResponseData();
            ReadShareGroupStateSummaryRequestData readShareGroupStateSummaryRequestData = (ReadShareGroupStateSummaryRequestData)request;
            readShareGroupStateSummaryRequestData.topics().forEach(topicData -> {
                ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult topicResponse = new ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult().setTopicId(topicData.topicId()).setPartitions(topicData.partitions().stream().map(partitionData -> new ReadShareGroupStateSummaryResponseData.PartitionResult().setPartition(partitionData.partition()).setErrorCode(errorCode).setErrorMessage(errorMessage)).toList());
                response.results().add(topicResponse);
            });
            return Optional.of(response);
        });
        ErrorResponseBuilderRegistry.registerSimpleApis();
        LOGGER.info("Initialized {} error creators ({} manual, {} reflection-based)", new Object[]{RESPONSE_CREATORS.size(), RESPONSE_CREATORS.size() - ErrorResponseBuilderRegistry.getReflectionBasedCount(), ErrorResponseBuilderRegistry.getReflectionBasedCount()});
    }

    private static int getReflectionBasedCount() {
        try {
            return SimpleApiErrorCreators.getAllErrorResponses().size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static ErrorResponseBuilder createDefaultErrorCreator() {
        return (apiKey, request, errorCode, errorMessage) -> {
            LOGGER.warn("No specific error creator found for API key: {}. Returning empty response.", (Object)apiKey);
            return Optional.empty();
        };
    }

    static {
        ErrorResponseBuilderRegistry.initializeErrorResponseBuilders();
    }
}

