/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.response;

import io.confluent.gateway.filter.authswap.response.ErrorResponseBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.message.AddOffsetsToTxnResponseData;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.message.AddRaftVoterResponseData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.AssignReplicasToDirsResponseData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.ControllerRegistrationResponseData;
import org.apache.kafka.common.message.CreateDelegationTokenResponseData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.message.DescribeDelegationTokenResponseData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.EndTxnResponseData;
import org.apache.kafka.common.message.EnvelopeResponseData;
import org.apache.kafka.common.message.ExpireDelegationTokenResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.message.GetTelemetrySubscriptionsResponseData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.InitProducerIdResponseData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListClientMetricsResourcesResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.PushTelemetryResponseData;
import org.apache.kafka.common.message.RemoveRaftVoterResponseData;
import org.apache.kafka.common.message.RenewDelegationTokenResponseData;
import org.apache.kafka.common.message.SaslAuthenticateResponseData;
import org.apache.kafka.common.message.SaslHandshakeResponseData;
import org.apache.kafka.common.message.ShareAcknowledgeResponseData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.UnregisterBrokerResponseData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.message.UpdateRaftVoterResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleApiErrorCreators {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleApiErrorCreators.class);
    private static final String SET_MESSAGE_NOT_FOUND_ERROR = "{} response does not support setting error messages but received: {}";

    public static Map<ApiKeys, ErrorResponseBuilder> getAllErrorResponses() {
        HashMap<ApiKeys, ErrorResponseBuilder> errorCreators = new HashMap<ApiKeys, ErrorResponseBuilder>();
        errorCreators.put(ApiKeys.FETCH, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createFetchErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.METADATA, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createMetadataErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.OFFSET_FETCH, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createOffsetFetchErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.FIND_COORDINATOR, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createFindCoordinatorErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.JOIN_GROUP, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createJoinGroupErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.HEARTBEAT, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createHeartbeatErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.LEAVE_GROUP, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createLeaveGroupErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.SYNC_GROUP, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createSyncGroupErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.LIST_GROUPS, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createListGroupsErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.SASL_HANDSHAKE, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createSaslHandshakeErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.API_VERSIONS, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createApiVersionsErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.INIT_PRODUCER_ID, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createInitProducerIdErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.ADD_PARTITIONS_TO_TXN, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createAddPartitionsToTxnErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.ADD_OFFSETS_TO_TXN, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createAddOffsetsToTxnErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.END_TXN, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createEndTxnErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.DESCRIBE_ACLS, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createDescribeAclsErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.DESCRIBE_LOG_DIRS, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createDescribeLogDirsErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.SASL_AUTHENTICATE, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createSaslAuthenticateErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.CREATE_DELEGATION_TOKEN, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createCreateDelegationTokenErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.RENEW_DELEGATION_TOKEN, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createRenewDelegationTokenErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.EXPIRE_DELEGATION_TOKEN, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createExpireDelegationTokenErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.DESCRIBE_DELEGATION_TOKEN, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createDescribeDelegationTokenErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.ELECT_LEADERS, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createElectLeadersErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.ALTER_PARTITION_REASSIGNMENTS, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createAlterPartitionReassignmentsErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.LIST_PARTITION_REASSIGNMENTS, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createListPartitionReassignmentsErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.OFFSET_DELETE, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createOffsetDeleteErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.DESCRIBE_CLIENT_QUOTAS, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createDescribeClientQuotasErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.DESCRIBE_USER_SCRAM_CREDENTIALS, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createDescribeUserScramCredentialsErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.VOTE, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createVoteErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.BEGIN_QUORUM_EPOCH, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createBeginQuorumEpochErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.END_QUORUM_EPOCH, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createEndQuorumEpochErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.DESCRIBE_QUORUM, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createDescribeQuorumErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.ALTER_PARTITION, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createAlterPartitionErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.UPDATE_FEATURES, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createUpdateFeaturesErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.ENVELOPE, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createEnvelopeErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.FETCH_SNAPSHOT, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createFetchSnapshotErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.DESCRIBE_CLUSTER, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createDescribeClusterErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.BROKER_REGISTRATION, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createBrokerRegistrationErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.BROKER_HEARTBEAT, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createBrokerHeartbeatErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.UNREGISTER_BROKER, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createUnregisterBrokerErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.LIST_TRANSACTIONS, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createListTransactionsErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.ALLOCATE_PRODUCER_IDS, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createAllocateProducerIdsErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.CONSUMER_GROUP_HEARTBEAT, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createConsumerGroupHeartbeatErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.CONTROLLER_REGISTRATION, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createControllerRegistrationErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.GET_TELEMETRY_SUBSCRIPTIONS, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createGetTelemetrySubscriptionsErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.PUSH_TELEMETRY, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createPushTelemetryErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.ASSIGN_REPLICAS_TO_DIRS, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createAssignReplicasToDirsErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.LIST_CLIENT_METRICS_RESOURCES, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createListClientMetricsResourcesErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.SHARE_GROUP_HEARTBEAT, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createShareGroupHeartbeatErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.SHARE_FETCH, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createShareFetchErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.SHARE_ACKNOWLEDGE, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createShareAcknowledgeErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.ADD_RAFT_VOTER, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createAddRaftVoterErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.REMOVE_RAFT_VOTER, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createRemoveRaftVoterErrorResponse(errorCode, errorMessage));
        errorCreators.put(ApiKeys.UPDATE_RAFT_VOTER, (apiKey, request, errorCode, errorMessage) -> SimpleApiErrorCreators.createUpdateRaftVoterErrorResponse(errorCode, errorMessage));
        return errorCreators;
    }

    public static Optional<ApiMessage> createFetchErrorResponse(short errorCode, String errorMessage) {
        FetchResponseData response = new FetchResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.FETCH, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createMetadataErrorResponse(short errorCode, String errorMessage) {
        MetadataResponseData response = new MetadataResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.METADATA, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createOffsetFetchErrorResponse(short errorCode, String errorMessage) {
        OffsetFetchResponseData response = new OffsetFetchResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.OFFSET_FETCH, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createFindCoordinatorErrorResponse(short errorCode, String errorMessage) {
        FindCoordinatorResponseData response = new FindCoordinatorResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createJoinGroupErrorResponse(short errorCode, String errorMessage) {
        JoinGroupResponseData response = new JoinGroupResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.JOIN_GROUP, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createHeartbeatErrorResponse(short errorCode, String errorMessage) {
        HeartbeatResponseData response = new HeartbeatResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.HEARTBEAT, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createLeaveGroupErrorResponse(short errorCode, String errorMessage) {
        LeaveGroupResponseData response = new LeaveGroupResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.LEAVE_GROUP, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createSyncGroupErrorResponse(short errorCode, String errorMessage) {
        SyncGroupResponseData response = new SyncGroupResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.SYNC_GROUP, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createListGroupsErrorResponse(short errorCode, String errorMessage) {
        ListGroupsResponseData response = new ListGroupsResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.LIST_GROUPS, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createSaslHandshakeErrorResponse(short errorCode, String errorMessage) {
        SaslHandshakeResponseData response = new SaslHandshakeResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.SASL_HANDSHAKE, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createApiVersionsErrorResponse(short errorCode, String errorMessage) {
        ApiVersionsResponseData response = new ApiVersionsResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.API_VERSIONS, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createInitProducerIdErrorResponse(short errorCode, String errorMessage) {
        InitProducerIdResponseData response = new InitProducerIdResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.INIT_PRODUCER_ID, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createAddPartitionsToTxnErrorResponse(short errorCode, String errorMessage) {
        AddPartitionsToTxnResponseData response = new AddPartitionsToTxnResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.ADD_PARTITIONS_TO_TXN, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createAddOffsetsToTxnErrorResponse(short errorCode, String errorMessage) {
        AddOffsetsToTxnResponseData response = new AddOffsetsToTxnResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.ADD_OFFSETS_TO_TXN, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createEndTxnErrorResponse(short errorCode, String errorMessage) {
        EndTxnResponseData response = new EndTxnResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.END_TXN, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createDescribeAclsErrorResponse(short errorCode, String errorMessage) {
        DescribeAclsResponseData response = new DescribeAclsResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createDescribeLogDirsErrorResponse(short errorCode, String errorMessage) {
        DescribeLogDirsResponseData response = new DescribeLogDirsResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.DESCRIBE_LOG_DIRS, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createSaslAuthenticateErrorResponse(short errorCode, String errorMessage) {
        SaslAuthenticateResponseData response = new SaslAuthenticateResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createCreateDelegationTokenErrorResponse(short errorCode, String errorMessage) {
        CreateDelegationTokenResponseData response = new CreateDelegationTokenResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.CREATE_DELEGATION_TOKEN, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createRenewDelegationTokenErrorResponse(short errorCode, String errorMessage) {
        RenewDelegationTokenResponseData response = new RenewDelegationTokenResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.RENEW_DELEGATION_TOKEN, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createExpireDelegationTokenErrorResponse(short errorCode, String errorMessage) {
        ExpireDelegationTokenResponseData response = new ExpireDelegationTokenResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.EXPIRE_DELEGATION_TOKEN, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createDescribeDelegationTokenErrorResponse(short errorCode, String errorMessage) {
        DescribeDelegationTokenResponseData response = new DescribeDelegationTokenResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.DESCRIBE_DELEGATION_TOKEN, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createElectLeadersErrorResponse(short errorCode, String errorMessage) {
        ElectLeadersResponseData response = new ElectLeadersResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.ELECT_LEADERS, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createAlterPartitionReassignmentsErrorResponse(short errorCode, String errorMessage) {
        AlterPartitionReassignmentsResponseData response = new AlterPartitionReassignmentsResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createListPartitionReassignmentsErrorResponse(short errorCode, String errorMessage) {
        ListPartitionReassignmentsResponseData response = new ListPartitionReassignmentsResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createOffsetDeleteErrorResponse(short errorCode, String errorMessage) {
        OffsetDeleteResponseData response = new OffsetDeleteResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.OFFSET_DELETE, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createDescribeClientQuotasErrorResponse(short errorCode, String errorMessage) {
        DescribeClientQuotasResponseData response = new DescribeClientQuotasResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createDescribeUserScramCredentialsErrorResponse(short errorCode, String errorMessage) {
        DescribeUserScramCredentialsResponseData response = new DescribeUserScramCredentialsResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createVoteErrorResponse(short errorCode, String errorMessage) {
        VoteResponseData response = new VoteResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.VOTE, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createBeginQuorumEpochErrorResponse(short errorCode, String errorMessage) {
        BeginQuorumEpochResponseData response = new BeginQuorumEpochResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.BEGIN_QUORUM_EPOCH, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createEndQuorumEpochErrorResponse(short errorCode, String errorMessage) {
        EndQuorumEpochResponseData response = new EndQuorumEpochResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.END_QUORUM_EPOCH, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createDescribeQuorumErrorResponse(short errorCode, String errorMessage) {
        DescribeQuorumResponseData response = new DescribeQuorumResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createAlterPartitionErrorResponse(short errorCode, String errorMessage) {
        AlterPartitionResponseData response = new AlterPartitionResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.ALTER_PARTITION, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createUpdateFeaturesErrorResponse(short errorCode, String errorMessage) {
        UpdateFeaturesResponseData response = new UpdateFeaturesResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createEnvelopeErrorResponse(short errorCode, String errorMessage) {
        EnvelopeResponseData response = new EnvelopeResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.ENVELOPE, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createFetchSnapshotErrorResponse(short errorCode, String errorMessage) {
        FetchSnapshotResponseData response = new FetchSnapshotResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.FETCH_SNAPSHOT, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createDescribeClusterErrorResponse(short errorCode, String errorMessage) {
        DescribeClusterResponseData response = new DescribeClusterResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createBrokerRegistrationErrorResponse(short errorCode, String errorMessage) {
        BrokerRegistrationResponseData response = new BrokerRegistrationResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.BROKER_REGISTRATION, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createBrokerHeartbeatErrorResponse(short errorCode, String errorMessage) {
        BrokerHeartbeatResponseData response = new BrokerHeartbeatResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.BROKER_HEARTBEAT, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createUnregisterBrokerErrorResponse(short errorCode, String errorMessage) {
        UnregisterBrokerResponseData response = new UnregisterBrokerResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createListTransactionsErrorResponse(short errorCode, String errorMessage) {
        ListTransactionsResponseData response = new ListTransactionsResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.LIST_TRANSACTIONS, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createAllocateProducerIdsErrorResponse(short errorCode, String errorMessage) {
        AllocateProducerIdsResponseData response = new AllocateProducerIdsResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.ALLOCATE_PRODUCER_IDS, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createConsumerGroupHeartbeatErrorResponse(short errorCode, String errorMessage) {
        ConsumerGroupHeartbeatResponseData response = new ConsumerGroupHeartbeatResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createControllerRegistrationErrorResponse(short errorCode, String errorMessage) {
        ControllerRegistrationResponseData response = new ControllerRegistrationResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createGetTelemetrySubscriptionsErrorResponse(short errorCode, String errorMessage) {
        GetTelemetrySubscriptionsResponseData response = new GetTelemetrySubscriptionsResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.GET_TELEMETRY_SUBSCRIPTIONS, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createPushTelemetryErrorResponse(short errorCode, String errorMessage) {
        PushTelemetryResponseData response = new PushTelemetryResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.PUSH_TELEMETRY, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createAssignReplicasToDirsErrorResponse(short errorCode, String errorMessage) {
        AssignReplicasToDirsResponseData response = new AssignReplicasToDirsResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.ASSIGN_REPLICAS_TO_DIRS, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createListClientMetricsResourcesErrorResponse(short errorCode, String errorMessage) {
        ListClientMetricsResourcesResponseData response = new ListClientMetricsResourcesResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.LIST_CLIENT_METRICS_RESOURCES, (Object)errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createShareGroupHeartbeatErrorResponse(short errorCode, String errorMessage) {
        ShareGroupHeartbeatResponseData response = new ShareGroupHeartbeatResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createShareFetchErrorResponse(short errorCode, String errorMessage) {
        ShareFetchResponseData response = new ShareFetchResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createShareAcknowledgeErrorResponse(short errorCode, String errorMessage) {
        ShareAcknowledgeResponseData response = new ShareAcknowledgeResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createAddRaftVoterErrorResponse(short errorCode, String errorMessage) {
        AddRaftVoterResponseData response = new AddRaftVoterResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createRemoveRaftVoterErrorResponse(short errorCode, String errorMessage) {
        RemoveRaftVoterResponseData response = new RemoveRaftVoterResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            response.setErrorMessage(errorMessage);
        }
        return Optional.of(response);
    }

    public static Optional<ApiMessage> createUpdateRaftVoterErrorResponse(short errorCode, String errorMessage) {
        UpdateRaftVoterResponseData response = new UpdateRaftVoterResponseData().setErrorCode(errorCode);
        if (errorMessage != null) {
            LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, (Object)ApiKeys.UPDATE_RAFT_VOTER, (Object)errorMessage);
        }
        return Optional.of(response);
    }
}

